/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.deeplearning4j.arbiter.BaseNetworkSpace;
import org.deeplearning4j.arbiter.GraphConfiguration;
import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.util.CollectionUtils;
import org.deeplearning4j.earlystopping.EarlyStoppingConfiguration;
import org.deeplearning4j.nn.conf.BackpropType;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.graph.ComputationGraph;

public class ComputationGraphSpace
extends BaseNetworkSpace<GraphConfiguration> {
    private List<LayerConf> layerSpaces = new ArrayList<LayerConf>();
    private List<VertexConf> vertices = new ArrayList<VertexConf>();
    private String[] networkInputs;
    private String[] networkOutputs;
    private InputType[] inputTypes;
    private int numParameters;
    private EarlyStoppingConfiguration<ComputationGraph> earlyStoppingConfiguration;

    private ComputationGraphSpace(Builder builder) {
        super(builder);
        this.earlyStoppingConfiguration = builder.earlyStoppingConfiguration;
        this.layerSpaces = builder.layerList;
        this.vertices = builder.vertexList;
        this.networkInputs = builder.networkInputs;
        this.networkOutputs = builder.networkOutputs;
        this.inputTypes = builder.inputTypes;
        List list = CollectionUtils.getUnique(this.collectLeaves());
        for (ParameterSpace ps : list) {
            this.numParameters += ps.numParameters();
        }
    }

    public GraphConfiguration getValue(double[] values) {
        NeuralNetConfiguration.Builder builder = this.randomGlobalConf(values);
        ComputationGraphConfiguration.GraphBuilder graphBuilder = builder.graphBuilder();
        graphBuilder.addInputs(this.networkInputs);
        graphBuilder.setOutputs(this.networkOutputs);
        if (this.inputTypes != null && this.inputTypes.length > 0) {
            graphBuilder.setInputTypes(this.inputTypes);
        }
        for (LayerConf c : this.layerSpaces) {
            Layer l = (Layer)c.layerSpace.getValue(values);
            graphBuilder.addLayer(c.getLayerName(), l, c.getInputs());
        }
        for (VertexConf gv : this.vertices) {
            graphBuilder.addVertex(gv.getVertexName(), gv.getGraphVertex(), gv.getInputs());
        }
        if (this.backprop != null) {
            graphBuilder.backprop(((Boolean)this.backprop.getValue(values)).booleanValue());
        }
        if (this.pretrain != null) {
            graphBuilder.pretrain(((Boolean)this.pretrain.getValue(values)).booleanValue());
        }
        if (this.backpropType != null) {
            graphBuilder.backpropType((BackpropType)this.backpropType.getValue(values));
        }
        if (this.tbpttFwdLength != null) {
            graphBuilder.tBPTTForwardLength(((Integer)this.tbpttFwdLength.getValue(values)).intValue());
        }
        if (this.tbpttBwdLength != null) {
            graphBuilder.tBPTTBackwardLength(((Integer)this.tbpttBwdLength.getValue(values)).intValue());
        }
        ComputationGraphConfiguration configuration = graphBuilder.build();
        return new GraphConfiguration(configuration, this.earlyStoppingConfiguration, this.numEpochs);
    }

    public int numParameters() {
        return this.numParameters;
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        List<ParameterSpace> list = super.collectLeaves();
        for (LayerConf lc : this.layerSpaces) {
            list.addAll(lc.layerSpace.collectLeaves());
        }
        if (this.cnnInputSize != null) {
            list.addAll(this.cnnInputSize.collectLeaves());
        }
        return list;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        for (LayerConf layerConf : this.layerSpaces) {
            sb.append("Layer config: \"").append(layerConf.layerName).append("\", ").append(layerConf.layerSpace).append(", inputs: ").append(layerConf.inputs == null ? "[]" : Arrays.toString(layerConf.inputs)).append("\n");
        }
        for (VertexConf vertexConf : this.vertices) {
            sb.append("GraphVertex: \"").append(vertexConf.vertexName).append("\", ").append(vertexConf.graphVertex).append(", inputs: ").append(vertexConf.inputs == null ? "[]" : Arrays.toString(vertexConf.inputs)).append("\n");
        }
        if (this.earlyStoppingConfiguration != null) {
            sb.append("Early stopping configuration:").append(this.earlyStoppingConfiguration.toString()).append("\n");
        } else {
            sb.append("Training # epochs:").append(this.numEpochs).append("\n");
        }
        return sb.toString();
    }

    public static class Builder
    extends BaseNetworkSpace.Builder<Builder> {
        protected List<LayerConf> layerList = new ArrayList<LayerConf>();
        protected List<VertexConf> vertexList = new ArrayList<VertexConf>();
        protected EarlyStoppingConfiguration<ComputationGraph> earlyStoppingConfiguration;
        protected String[] networkInputs;
        protected String[] networkOutputs;
        protected InputType[] inputTypes;

        public Builder earlyStoppingConfiguration(EarlyStoppingConfiguration<ComputationGraph> earlyStoppingConfiguration) {
            this.earlyStoppingConfiguration = earlyStoppingConfiguration;
            return this;
        }

        public Builder addLayer(String layerName, LayerSpace<? extends Layer> layerSpace, String ... layerInputs) {
            this.layerList.add(new LayerConf(layerSpace, layerName, layerInputs));
            return this;
        }

        public Builder addVertex(String vertexName, GraphVertex vertex, String ... vertexInputs) {
            this.vertexList.add(new VertexConf(vertex, vertexName, vertexInputs));
            return this;
        }

        public Builder addInputs(String ... networkInputs) {
            this.networkInputs = networkInputs;
            return this;
        }

        public Builder setOutputs(String ... networkOutputs) {
            this.networkOutputs = networkOutputs;
            return this;
        }

        public Builder setInputTypes(InputType ... inputTypes) {
            this.inputTypes = inputTypes;
            return this;
        }

        @Override
        public ComputationGraphSpace build() {
            return new ComputationGraphSpace(this);
        }
    }

    private static class VertexConf {
        private final GraphVertex graphVertex;
        private final String vertexName;
        private final String[] inputs;

        @ConstructorProperties(value={"graphVertex", "vertexName", "inputs"})
        public VertexConf(GraphVertex graphVertex, String vertexName, String[] inputs) {
            this.graphVertex = graphVertex;
            this.vertexName = vertexName;
            this.inputs = inputs;
        }

        public GraphVertex getGraphVertex() {
            return this.graphVertex;
        }

        public String getVertexName() {
            return this.vertexName;
        }

        public String[] getInputs() {
            return this.inputs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VertexConf)) {
                return false;
            }
            VertexConf other = (VertexConf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            GraphVertex this$graphVertex = this.getGraphVertex();
            GraphVertex other$graphVertex = other.getGraphVertex();
            if (this$graphVertex == null ? other$graphVertex != null : !this$graphVertex.equals(other$graphVertex)) {
                return false;
            }
            String this$vertexName = this.getVertexName();
            String other$vertexName = other.getVertexName();
            if (this$vertexName == null ? other$vertexName != null : !this$vertexName.equals(other$vertexName)) {
                return false;
            }
            return Arrays.deepEquals(this.getInputs(), other.getInputs());
        }

        protected boolean canEqual(Object other) {
            return other instanceof VertexConf;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GraphVertex $graphVertex = this.getGraphVertex();
            result = result * 59 + ($graphVertex == null ? 43 : $graphVertex.hashCode());
            String $vertexName = this.getVertexName();
            result = result * 59 + ($vertexName == null ? 43 : $vertexName.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getInputs());
            return result;
        }

        public String toString() {
            return "ComputationGraphSpace.VertexConf(graphVertex=" + this.getGraphVertex() + ", vertexName=" + this.getVertexName() + ", inputs=" + Arrays.deepToString(this.getInputs()) + ")";
        }
    }

    private static class LayerConf {
        private final LayerSpace<?> layerSpace;
        private final String layerName;
        private final String[] inputs;

        @ConstructorProperties(value={"layerSpace", "layerName", "inputs"})
        public LayerConf(LayerSpace<?> layerSpace, String layerName, String[] inputs) {
            this.layerSpace = layerSpace;
            this.layerName = layerName;
            this.inputs = inputs;
        }

        public LayerSpace<?> getLayerSpace() {
            return this.layerSpace;
        }

        public String getLayerName() {
            return this.layerName;
        }

        public String[] getInputs() {
            return this.inputs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LayerConf)) {
                return false;
            }
            LayerConf other = (LayerConf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LayerSpace<?> this$layerSpace = this.getLayerSpace();
            LayerSpace<?> other$layerSpace = other.getLayerSpace();
            if (this$layerSpace == null ? other$layerSpace != null : !this$layerSpace.equals(other$layerSpace)) {
                return false;
            }
            String this$layerName = this.getLayerName();
            String other$layerName = other.getLayerName();
            if (this$layerName == null ? other$layerName != null : !this$layerName.equals(other$layerName)) {
                return false;
            }
            return Arrays.deepEquals(this.getInputs(), other.getInputs());
        }

        protected boolean canEqual(Object other) {
            return other instanceof LayerConf;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LayerSpace<?> $layerSpace = this.getLayerSpace();
            result = result * 59 + ($layerSpace == null ? 43 : $layerSpace.hashCode());
            String $layerName = this.getLayerName();
            result = result * 59 + ($layerName == null ? 43 : $layerName.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getInputs());
            return result;
        }

        public String toString() {
            return "ComputationGraphSpace.LayerConf(layerSpace=" + this.getLayerSpace() + ", layerName=" + this.getLayerName() + ", inputs=" + Arrays.deepToString(this.getInputs()) + ")";
        }
    }
}

