/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.evaluator.multilayer;

import org.deeplearning4j.arbiter.optimize.api.data.DataProvider;
import org.deeplearning4j.arbiter.optimize.api.evaluation.ModelEvaluator;
import org.deeplearning4j.eval.Evaluation;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class ClassificationEvaluator
implements ModelEvaluator<MultiLayerNetwork, DataSetIterator, Evaluation> {
    public Evaluation evaluateModel(MultiLayerNetwork model, DataProvider<DataSetIterator> dataProvider) {
        DataSetIterator iterator = (DataSetIterator)dataProvider.testData(null);
        Evaluation eval = new Evaluation();
        while (iterator.hasNext()) {
            DataSet ds = (DataSet)iterator.next();
            INDArray features = ds.getFeatures();
            INDArray labels = ds.getLabels();
            if (ds.hasMaskArrays()) {
                INDArray fMask = ds.getFeaturesMaskArray();
                INDArray lMask = ds.getLabelsMaskArray();
                INDArray out = model.output(ds.getFeatures(), false, fMask, lMask);
                if (lMask != null) {
                    eval.evalTimeSeries(labels, out, lMask);
                    continue;
                }
                eval.evalTimeSeries(labels, out);
                continue;
            }
            INDArray out = model.output(features);
            if (out.rank() == 3) {
                eval.evalTimeSeries(labels, out);
                continue;
            }
            eval.eval(labels, out);
        }
        return eval;
    }
}

