/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import java.util.List;
import org.deeplearning4j.arbiter.layers.FeedForwardLayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.CollectionUtils;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;

public class BatchNormalizationSpace
extends FeedForwardLayerSpace<BatchNormalization> {
    protected ParameterSpace<Double> decay;
    protected ParameterSpace<Double> eps;
    protected ParameterSpace<Boolean> isMinibatch;
    protected ParameterSpace<Boolean> lockGammaBeta;
    protected ParameterSpace<Double> gamma;
    protected ParameterSpace<Double> beta;

    private BatchNormalizationSpace(Builder builder) {
        super(builder);
        this.decay = builder.decay;
        this.eps = builder.eps;
        this.isMinibatch = builder.isMinibatch;
        this.lockGammaBeta = builder.lockGammaBeta;
        this.gamma = builder.gamma;
        this.beta = builder.beta;
        this.numParameters = CollectionUtils.countUnique(this.collectLeaves());
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        List<ParameterSpace> list = super.collectLeaves();
        if (this.decay != null) {
            list.addAll(this.decay.collectLeaves());
        }
        if (this.eps != null) {
            list.addAll(this.eps.collectLeaves());
        }
        if (this.isMinibatch != null) {
            list.addAll(this.isMinibatch.collectLeaves());
        }
        if (this.lockGammaBeta != null) {
            list.addAll(this.lockGammaBeta.collectLeaves());
        }
        if (this.gamma != null) {
            list.addAll(this.gamma.collectLeaves());
        }
        if (this.beta != null) {
            list.addAll(this.beta.collectLeaves());
        }
        return list;
    }

    public BatchNormalization getValue(double[] parameterValues) {
        BatchNormalization.Builder b = new BatchNormalization.Builder();
        this.setLayerOptionsBuilder(b, parameterValues);
        return b.build();
    }

    protected void setLayerOptionsBuilder(BatchNormalization.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((FeedForwardLayer.Builder)builder, values);
        if (this.decay != null) {
            builder.decay(((Double)this.decay.getValue(values)).doubleValue());
        }
        if (this.eps != null) {
            builder.eps(((Double)this.eps.getValue(values)).doubleValue());
        }
        if (this.isMinibatch != null) {
            builder.minibatch(((Boolean)this.isMinibatch.getValue(values)).booleanValue());
        }
        if (this.lockGammaBeta != null) {
            builder.lockGammaBeta(((Boolean)this.lockGammaBeta.getValue(values)).booleanValue());
        }
        if (this.gamma != null) {
            builder.gamma(((Double)this.gamma.getValue(values)).doubleValue());
        }
        if (this.beta != null) {
            builder.beta(((Double)this.beta.getValue(values)).doubleValue());
        }
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    public String toString(String delim) {
        StringBuilder sb = new StringBuilder();
        sb.append("BatchNormalizationSpace(").append(super.toString(delim));
        if (this.decay != null) {
            sb.append("decay: ").append(this.decay).append(delim);
        }
        if (this.eps != null) {
            sb.append("eps: ").append(this.eps).append(delim);
        }
        if (this.isMinibatch != null) {
            sb.append("isMinibatch: ").append(this.isMinibatch).append(delim);
        }
        if (this.lockGammaBeta != null) {
            sb.append("lockGammaBeta: ").append(this.lockGammaBeta).append(delim);
        }
        if (this.gamma != null) {
            sb.append("gamma: ").append(this.gamma).append(delim);
        }
        if (this.beta != null) {
            sb.append("beta: ").append(this.beta).append(delim);
        }
        sb.append(")");
        return sb.toString();
    }

    public static class Builder
    extends FeedForwardLayerSpace.Builder<Builder> {
        protected ParameterSpace<Double> decay;
        protected ParameterSpace<Double> eps;
        protected ParameterSpace<Boolean> isMinibatch;
        protected ParameterSpace<Boolean> lockGammaBeta;
        protected ParameterSpace<Double> gamma;
        protected ParameterSpace<Double> beta;

        public Builder minibatch(boolean minibatch) {
            return this.minibatch((ParameterSpace<Boolean>)new FixedValue((Object)minibatch));
        }

        public Builder minibatch(ParameterSpace<Boolean> minibatch) {
            this.isMinibatch = minibatch;
            return this;
        }

        public Builder gamma(double gamma) {
            return this.gamma((ParameterSpace<Double>)new FixedValue((Object)gamma));
        }

        public Builder gamma(ParameterSpace<Double> gamma) {
            this.gamma = gamma;
            return this;
        }

        public Builder beta(double beta) {
            return this.beta((ParameterSpace<Double>)new FixedValue((Object)beta));
        }

        public Builder beta(ParameterSpace<Double> beta) {
            this.beta = beta;
            return this;
        }

        public Builder eps(double eps) {
            return this.eps((ParameterSpace<Double>)new FixedValue((Object)eps));
        }

        public Builder eps(ParameterSpace<Double> eps) {
            this.eps = eps;
            return this;
        }

        public Builder decay(double decay) {
            return this.decay((ParameterSpace<Double>)new FixedValue((Object)decay));
        }

        public Builder decay(ParameterSpace<Double> decay) {
            this.decay = decay;
            return this;
        }

        public Builder lockGammaBeta(boolean lockGammaBeta) {
            return this.lockGammaBeta((ParameterSpace<Boolean>)new FixedValue((Object)lockGammaBeta));
        }

        public Builder lockGammaBeta(ParameterSpace<Boolean> lockGammaBeta) {
            this.lockGammaBeta = lockGammaBeta;
            return this;
        }

        @Override
        public BatchNormalizationSpace build() {
            return new BatchNormalizationSpace(this);
        }
    }
}

