/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import java.util.List;
import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.Layer;

public abstract class FeedForwardLayerSpace<L extends FeedForwardLayer>
extends LayerSpace<L> {
    protected ParameterSpace<Integer> nIn;
    protected ParameterSpace<Integer> nOut;

    protected FeedForwardLayerSpace(Builder builder) {
        super(builder);
        this.nIn = builder.nIn;
        this.nOut = builder.nOut;
    }

    protected void setLayerOptionsBuilder(FeedForwardLayer.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((Layer.Builder)builder, values);
        if (this.nIn != null) {
            builder.nIn(((Integer)this.nIn.getValue(values)).intValue());
        }
        if (this.nOut != null) {
            builder.nOut(((Integer)this.nOut.getValue(values)).intValue());
        }
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        List<ParameterSpace> list = super.collectLeaves();
        if (this.nIn != null) {
            list.addAll(this.nIn.collectLeaves());
        }
        if (this.nOut != null) {
            list.addAll(this.nOut.collectLeaves());
        }
        return list;
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    protected String toString(String delim) {
        StringBuilder sb = new StringBuilder();
        if (this.nIn != null) {
            sb.append("nIn: ").append(this.nIn).append(delim);
        }
        if (this.nOut != null) {
            sb.append("nOut: ").append(this.nOut).append(delim);
        }
        sb.append(super.toString(delim));
        return sb.toString();
    }

    public static abstract class Builder<T>
    extends LayerSpace.Builder<T> {
        protected ParameterSpace<Integer> nIn;
        protected ParameterSpace<Integer> nOut;

        public T nIn(int nIn) {
            return this.nIn((ParameterSpace<Integer>)new FixedValue((Object)nIn));
        }

        public T nIn(ParameterSpace<Integer> nIn) {
            this.nIn = nIn;
            return (T)this;
        }

        public T nOut(int nOut) {
            return this.nOut((ParameterSpace<Integer>)new FixedValue((Object)nOut));
        }

        public T nOut(ParameterSpace<Integer> nOut) {
            this.nOut = nOut;
            return (T)this;
        }
    }
}

