/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.weights.WeightInit;

public abstract class LayerSpace<L extends Layer>
implements ParameterSpace<L> {
    protected ParameterSpace<String> activationFunction;
    protected ParameterSpace<WeightInit> weightInit;
    protected ParameterSpace<Double> biasInit;
    protected ParameterSpace<Distribution> dist;
    protected ParameterSpace<Double> learningRate;
    protected ParameterSpace<Double> biasLearningRate;
    protected ParameterSpace<Map<Integer, Double>> learningRateAfter;
    protected ParameterSpace<Double> lrScoreBasedDecay;
    protected ParameterSpace<Double> l1;
    protected ParameterSpace<Double> l2;
    protected ParameterSpace<Double> dropOut;
    protected ParameterSpace<Double> momentum;
    protected ParameterSpace<Map<Integer, Double>> momentumAfter;
    protected ParameterSpace<Updater> updater;
    protected ParameterSpace<Double> epsilon;
    protected ParameterSpace<Double> rho;
    protected ParameterSpace<Double> rmsDecay;
    protected ParameterSpace<Double> adamMeanDecay;
    protected ParameterSpace<Double> adamVarDecay;
    protected ParameterSpace<GradientNormalization> gradientNormalization;
    protected ParameterSpace<Double> gradientNormalizationThreshold;
    protected int numParameters;

    protected LayerSpace(Builder builder) {
        this.activationFunction = builder.activationFunction;
        this.weightInit = builder.weightInit;
        this.biasInit = builder.biasInit;
        this.dist = builder.dist;
        this.learningRate = builder.learningRate;
        this.biasLearningRate = builder.biasLearningRate;
        this.learningRateAfter = builder.learningRateAfter;
        this.lrScoreBasedDecay = builder.lrScoreBasedDecay;
        this.l1 = builder.l1;
        this.l2 = builder.l2;
        this.dropOut = builder.dropOut;
        this.momentum = builder.momentum;
        this.momentumAfter = builder.momentumAfter;
        this.updater = builder.updater;
        this.epsilon = builder.epsilon;
        this.rho = builder.rho;
        this.rmsDecay = builder.rmsDecay;
        this.adamMeanDecay = builder.adamMeanDecay;
        this.adamVarDecay = builder.adamVarDecay;
        this.gradientNormalization = builder.gradientNormalization;
        this.gradientNormalizationThreshold = builder.gradientNormalizationThreshold;
    }

    public List<ParameterSpace> collectLeaves() {
        ArrayList<ParameterSpace> list = new ArrayList<ParameterSpace>();
        if (this.activationFunction != null) {
            list.addAll(this.activationFunction.collectLeaves());
        }
        if (this.weightInit != null) {
            list.addAll(this.weightInit.collectLeaves());
        }
        if (this.biasInit != null) {
            list.addAll(this.biasInit.collectLeaves());
        }
        if (this.dist != null) {
            list.addAll(this.dist.collectLeaves());
        }
        if (this.learningRate != null) {
            list.addAll(this.learningRate.collectLeaves());
        }
        if (this.biasLearningRate != null) {
            list.addAll(this.biasLearningRate.collectLeaves());
        }
        if (this.learningRateAfter != null) {
            list.addAll(this.learningRateAfter.collectLeaves());
        }
        if (this.lrScoreBasedDecay != null) {
            list.addAll(this.lrScoreBasedDecay.collectLeaves());
        }
        if (this.l1 != null) {
            list.addAll(this.l1.collectLeaves());
        }
        if (this.l2 != null) {
            list.addAll(this.l2.collectLeaves());
        }
        if (this.dropOut != null) {
            list.addAll(this.dropOut.collectLeaves());
        }
        if (this.momentum != null) {
            list.addAll(this.momentum.collectLeaves());
        }
        if (this.momentumAfter != null) {
            list.addAll(this.momentumAfter.collectLeaves());
        }
        if (this.updater != null) {
            list.addAll(this.updater.collectLeaves());
        }
        if (this.epsilon != null) {
            list.addAll(this.epsilon.collectLeaves());
        }
        if (this.rho != null) {
            list.addAll(this.rho.collectLeaves());
        }
        if (this.rmsDecay != null) {
            list.addAll(this.rmsDecay.collectLeaves());
        }
        if (this.adamMeanDecay != null) {
            list.addAll(this.adamMeanDecay.collectLeaves());
        }
        if (this.adamVarDecay != null) {
            list.addAll(this.adamVarDecay.collectLeaves());
        }
        if (this.gradientNormalization != null) {
            list.addAll(this.gradientNormalization.collectLeaves());
        }
        if (this.gradientNormalizationThreshold != null) {
            list.addAll(this.gradientNormalizationThreshold.collectLeaves());
        }
        return list;
    }

    public int numParameters() {
        return this.numParameters;
    }

    public boolean isLeaf() {
        return false;
    }

    public void setIndices(int ... indices) {
        throw new UnsupportedOperationException("Cannot set indices for non-leaf parameter space");
    }

    protected void setLayerOptionsBuilder(Layer.Builder builder, double[] values) {
        if (this.activationFunction != null) {
            builder.activation((String)this.activationFunction.getValue(values));
        }
        if (this.weightInit != null) {
            builder.weightInit((WeightInit)this.weightInit.getValue(values));
        }
        if (this.biasInit != null) {
            builder.biasInit(((Double)this.biasInit.getValue(values)).doubleValue());
        }
        if (this.dist != null) {
            builder.dist((Distribution)this.dist.getValue(values));
        }
        if (this.learningRate != null) {
            builder.learningRate(((Double)this.learningRate.getValue(values)).doubleValue());
        }
        if (this.biasLearningRate != null) {
            builder.biasLearningRate(((Double)this.biasLearningRate.getValue(values)).doubleValue());
        }
        if (this.learningRateAfter != null) {
            builder.learningRateSchedule((Map)this.learningRateAfter.getValue(values));
        }
        if (this.lrScoreBasedDecay != null) {
            builder.learningRate(((Double)this.lrScoreBasedDecay.getValue(values)).doubleValue());
        }
        if (this.l1 != null) {
            builder.l1(((Double)this.l1.getValue(values)).doubleValue());
        }
        if (this.l2 != null) {
            builder.l2(((Double)this.l2.getValue(values)).doubleValue());
        }
        if (this.dropOut != null) {
            builder.dropOut(((Double)this.dropOut.getValue(values)).doubleValue());
        }
        if (this.momentum != null) {
            builder.momentum(((Double)this.momentum.getValue(values)).doubleValue());
        }
        if (this.momentumAfter != null) {
            builder.momentumAfter((Map)this.momentumAfter.getValue(values));
        }
        if (this.updater != null) {
            builder.updater((Updater)this.updater.getValue(values));
        }
        if (this.epsilon != null) {
            builder.epsilon(((Double)this.epsilon.getValue(values)).doubleValue());
        }
        if (this.rho != null) {
            builder.rho(((Double)this.rho.getValue(values)).doubleValue());
        }
        if (this.rmsDecay != null) {
            builder.rmsDecay(((Double)this.rmsDecay.getValue(values)).doubleValue());
        }
        if (this.adamMeanDecay != null) {
            builder.adamMeanDecay(((Double)this.adamMeanDecay.getValue(values)).doubleValue());
        }
        if (this.adamVarDecay != null) {
            builder.adamVarDecay(((Double)this.adamVarDecay.getValue(values)).doubleValue());
        }
        if (this.gradientNormalization != null) {
            builder.gradientNormalization((GradientNormalization)this.gradientNormalization.getValue(values));
        }
        if (this.gradientNormalizationThreshold != null) {
            builder.gradientNormalizationThreshold(((Double)this.gradientNormalizationThreshold.getValue(values)).doubleValue());
        }
    }

    public String toString() {
        return this.toString(", ");
    }

    protected String toString(String delim) {
        String s;
        StringBuilder sb = new StringBuilder();
        if (this.activationFunction != null) {
            sb.append("activationFunction: ").append(this.activationFunction).append(delim);
        }
        if (this.weightInit != null) {
            sb.append("weightInit: ").append(this.weightInit).append(delim);
        }
        if (this.biasInit != null) {
            sb.append("biasInit: ").append(this.biasInit).append(delim);
        }
        if (this.dist != null) {
            sb.append("dist: ").append(this.dist).append(delim);
        }
        if (this.learningRate != null) {
            sb.append("learningRate: ").append(this.learningRate).append(delim);
        }
        if (this.biasLearningRate != null) {
            sb.append("biasLearningRate: ").append(this.biasLearningRate).append(delim);
        }
        if (this.learningRateAfter != null) {
            sb.append("learningRateAfter: ").append(this.learningRateAfter).append(delim);
        }
        if (this.lrScoreBasedDecay != null) {
            sb.append("lrScoreBasedDecay: ").append(this.lrScoreBasedDecay).append(delim);
        }
        if (this.l1 != null) {
            sb.append("l1: ").append(this.l1).append(delim);
        }
        if (this.l2 != null) {
            sb.append("l2: ").append(this.l2).append(delim);
        }
        if (this.dropOut != null) {
            sb.append("dropOut: ").append(this.dropOut).append(delim);
        }
        if (this.momentum != null) {
            sb.append("momentum: ").append(this.momentum).append(delim);
        }
        if (this.momentumAfter != null) {
            sb.append("momentumAfter: ").append(this.momentumAfter).append(delim);
        }
        if (this.updater != null) {
            sb.append("updater: ").append(this.updater).append(delim);
        }
        if (this.epsilon != null) {
            sb.append("epsilon: ").append(this.epsilon).append(delim);
        }
        if (this.rho != null) {
            sb.append("rho: ").append(this.rho).append(delim);
        }
        if (this.rmsDecay != null) {
            sb.append("rmsDecay: ").append(this.rmsDecay).append(delim);
        }
        if (this.adamMeanDecay != null) {
            sb.append("adamMeanDecay: ").append(this.adamMeanDecay).append(delim);
        }
        if (this.adamVarDecay != null) {
            sb.append("adamVarDecay: ").append(this.adamVarDecay).append(delim);
        }
        if (this.gradientNormalization != null) {
            sb.append("gradientNormalization: ").append(this.gradientNormalization).append(delim);
        }
        if (this.gradientNormalizationThreshold != null) {
            sb.append("gradientNormalizationThreshold").append(this.gradientNormalizationThreshold);
        }
        if ((s = sb.toString()).endsWith(delim)) {
            int last = s.lastIndexOf(delim);
            return s.substring(0, last);
        }
        return s;
    }

    public static abstract class Builder<T> {
        protected ParameterSpace<String> activationFunction;
        protected ParameterSpace<WeightInit> weightInit;
        protected ParameterSpace<Double> biasInit;
        protected ParameterSpace<Distribution> dist;
        protected ParameterSpace<Double> learningRate;
        protected ParameterSpace<Double> biasLearningRate;
        protected ParameterSpace<Map<Integer, Double>> learningRateAfter;
        protected ParameterSpace<Double> lrScoreBasedDecay;
        protected ParameterSpace<Double> l1;
        protected ParameterSpace<Double> l2;
        protected ParameterSpace<Double> dropOut;
        protected ParameterSpace<Updater> updater;
        protected ParameterSpace<Double> momentum;
        protected ParameterSpace<Map<Integer, Double>> momentumAfter;
        protected ParameterSpace<Double> epsilon;
        protected ParameterSpace<Double> rho;
        protected ParameterSpace<Double> rmsDecay;
        protected ParameterSpace<Double> adamMeanDecay;
        protected ParameterSpace<Double> adamVarDecay;
        protected ParameterSpace<GradientNormalization> gradientNormalization;
        protected ParameterSpace<Double> gradientNormalizationThreshold;

        public T activation(String activationFunction) {
            return this.activation((ParameterSpace<String>)new FixedValue((Object)activationFunction));
        }

        public T activation(ParameterSpace<String> activationFunction) {
            this.activationFunction = activationFunction;
            return (T)this;
        }

        public T weightInit(WeightInit weightInit) {
            return this.weightInit((ParameterSpace<WeightInit>)new FixedValue((Object)weightInit));
        }

        public T weightInit(ParameterSpace<WeightInit> weightInit) {
            this.weightInit = weightInit;
            return (T)this;
        }

        public T dist(Distribution dist) {
            return this.dist((ParameterSpace<Distribution>)new FixedValue((Object)dist));
        }

        public T dist(ParameterSpace<Distribution> dist) {
            this.dist = dist;
            return (T)this;
        }

        public T learningRate(double learningRate) {
            return this.learningRate((ParameterSpace<Double>)new FixedValue((Object)learningRate));
        }

        public T learningRate(ParameterSpace<Double> learningRate) {
            this.learningRate = learningRate;
            return (T)this;
        }

        public T biasLearningRate(double biasLearningRate) {
            return this.biasLearningRate((ParameterSpace<Double>)new FixedValue((Object)biasLearningRate));
        }

        public T biasLearningRate(ParameterSpace<Double> biasLearningRate) {
            this.biasLearningRate = biasLearningRate;
            return (T)this;
        }

        public T learningRateAfter(Map<Integer, Double> learningRateAfter) {
            return this.learningRateAfter((ParameterSpace<Map<Integer, Double>>)new FixedValue(learningRateAfter));
        }

        public T learningRateAfter(ParameterSpace<Map<Integer, Double>> learningRateAfter) {
            this.learningRateAfter = learningRateAfter;
            return (T)this;
        }

        public T learningRateScoreBasedDecayRate(double lrScoreBasedDecay) {
            return this.learningRateScoreBasedDecayRate((ParameterSpace<Double>)new FixedValue((Object)lrScoreBasedDecay));
        }

        public T learningRateScoreBasedDecayRate(ParameterSpace<Double> lrScoreBasedDecay) {
            this.lrScoreBasedDecay = lrScoreBasedDecay;
            return (T)this;
        }

        public T l1(double l1) {
            return this.l1((ParameterSpace<Double>)new FixedValue((Object)l1));
        }

        public T l1(ParameterSpace<Double> l1) {
            this.l1 = l1;
            return (T)this;
        }

        public T l2(double l2) {
            return this.l2((ParameterSpace<Double>)new FixedValue((Object)l2));
        }

        public T l2(ParameterSpace<Double> l2) {
            this.l2 = l2;
            return (T)this;
        }

        public T dropOut(double dropOut) {
            return this.dropOut((ParameterSpace<Double>)new FixedValue((Object)dropOut));
        }

        public T dropOut(ParameterSpace<Double> dropOut) {
            this.dropOut = dropOut;
            return (T)this;
        }

        public T momentum(double momentum) {
            return this.momentum((ParameterSpace<Double>)new FixedValue((Object)momentum));
        }

        public T momentum(ParameterSpace<Double> momentum) {
            this.momentum = momentum;
            return (T)this;
        }

        public T momentumAfter(Map<Integer, Double> momentumAfter) {
            return this.momentumAfter((ParameterSpace<Map<Integer, Double>>)new FixedValue(momentumAfter));
        }

        public T momentumAfter(ParameterSpace<Map<Integer, Double>> momentumAfter) {
            this.momentumAfter = momentumAfter;
            return (T)this;
        }

        public T updater(Updater updater) {
            return this.updater((ParameterSpace<Updater>)new FixedValue((Object)updater));
        }

        public T updater(ParameterSpace<Updater> updater) {
            this.updater = updater;
            return (T)this;
        }

        public T epsilon(double epsilon) {
            return this.epsilon((ParameterSpace<Double>)new FixedValue((Object)epsilon));
        }

        public T epsilon(ParameterSpace<Double> epsilon) {
            this.epsilon = epsilon;
            return (T)this;
        }

        public T rho(double rho) {
            return this.rho((ParameterSpace<Double>)new FixedValue((Object)rho));
        }

        public T rho(ParameterSpace<Double> rho) {
            this.rho = rho;
            return (T)this;
        }

        public T rmsDecay(double rmsDecay) {
            return this.rmsDecay((ParameterSpace<Double>)new FixedValue((Object)rmsDecay));
        }

        public T rmsDecay(ParameterSpace<Double> rmsDecay) {
            this.rmsDecay = rmsDecay;
            return (T)this;
        }

        public T adamMeanDecay(double adamMeanDecay) {
            return this.adamMeanDecay((ParameterSpace<Double>)new FixedValue((Object)adamMeanDecay));
        }

        public T adamMeanDecay(ParameterSpace<Double> adamMeanDecay) {
            this.adamMeanDecay = adamMeanDecay;
            return (T)this;
        }

        public T adamVarDecay(double adamVarDecay) {
            return this.adamVarDecay((ParameterSpace<Double>)new FixedValue((Object)adamVarDecay));
        }

        public T adamVarDecay(ParameterSpace<Double> adamVarDecay) {
            this.adamVarDecay = adamVarDecay;
            return (T)this;
        }

        public T gradientNormalization(GradientNormalization gradientNormalization) {
            return this.gradientNormalization((ParameterSpace<GradientNormalization>)new FixedValue((Object)gradientNormalization));
        }

        public T gradientNormalization(ParameterSpace<GradientNormalization> gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
            return (T)this;
        }

        public T gradientNormalizationThreshold(double threshold) {
            return this.gradientNormalizationThreshold((ParameterSpace<Double>)new FixedValue((Object)threshold));
        }

        public T gradientNormalizationThreshold(ParameterSpace<Double> gradientNormalizationThreshold) {
            this.gradientNormalizationThreshold = gradientNormalizationThreshold;
            return (T)this;
        }

        public abstract <E extends LayerSpace> E build();
    }
}

