/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import java.util.List;
import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.CollectionUtils;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.LocalResponseNormalization;

public class LocalResponseNormalizationLayerSpace
extends LayerSpace<LocalResponseNormalization> {
    private ParameterSpace<Double> n;
    private ParameterSpace<Double> k;
    private ParameterSpace<Double> alpha;
    private ParameterSpace<Double> beta;

    private LocalResponseNormalizationLayerSpace(Builder builder) {
        super(builder);
        this.n = builder.n;
        this.k = builder.k;
        this.alpha = builder.alpha;
        this.beta = builder.beta;
        this.numParameters = CollectionUtils.countUnique(this.collectLeaves());
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        List<ParameterSpace> list = super.collectLeaves();
        if (this.n != null) {
            list.addAll(this.n.collectLeaves());
        }
        if (this.k != null) {
            list.addAll(this.k.collectLeaves());
        }
        if (this.alpha != null) {
            list.addAll(this.alpha.collectLeaves());
        }
        if (this.beta != null) {
            list.addAll(this.beta.collectLeaves());
        }
        return list;
    }

    public LocalResponseNormalization getValue(double[] values) {
        LocalResponseNormalization.Builder b = new LocalResponseNormalization.Builder();
        this.setLayerOptionsBuilder(b, values);
        return b.build();
    }

    protected void setLayerOptionsBuilder(LocalResponseNormalization.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((Layer.Builder)builder, values);
        if (this.n != null) {
            builder.n(((Double)this.n.getValue(values)).doubleValue());
        }
        if (this.k != null) {
            builder.k(((Double)this.k.getValue(values)).doubleValue());
        }
        if (this.alpha != null) {
            builder.alpha(((Double)this.alpha.getValue(values)).doubleValue());
        }
        if (this.beta != null) {
            builder.beta(((Double)this.beta.getValue(values)).doubleValue());
        }
    }

    public static class Builder
    extends LayerSpace.Builder<Builder> {
        private ParameterSpace<Double> n;
        private ParameterSpace<Double> k;
        private ParameterSpace<Double> alpha;
        private ParameterSpace<Double> beta;

        public Builder n(double n) {
            return this.n((ParameterSpace<Double>)new FixedValue((Object)n));
        }

        public Builder n(ParameterSpace<Double> n) {
            this.n = n;
            return this;
        }

        public Builder k(double k) {
            return this.k((ParameterSpace<Double>)new FixedValue((Object)k));
        }

        public Builder k(ParameterSpace<Double> k) {
            this.k = k;
            return this;
        }

        public Builder alpha(double alpha) {
            return this.alpha((ParameterSpace<Double>)new FixedValue((Object)alpha));
        }

        public Builder alpha(ParameterSpace<Double> alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder beta(double beta) {
            return this.beta((ParameterSpace<Double>)new FixedValue((Object)beta));
        }

        public Builder beta(ParameterSpace<Double> beta) {
            this.beta = beta;
            return this;
        }

        @Override
        public LocalResponseNormalizationLayerSpace build() {
            return new LocalResponseNormalizationLayerSpace(this);
        }
    }
}

