/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import java.util.List;
import org.deeplearning4j.arbiter.layers.BasePretrainNetworkLayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.CollectionUtils;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.RBM;

public class RBMLayerSpace
extends BasePretrainNetworkLayerSpace<RBM> {
    private ParameterSpace<RBM.HiddenUnit> hiddenUnit;
    private ParameterSpace<RBM.VisibleUnit> visibleUnit;
    private ParameterSpace<Integer> k;
    private ParameterSpace<Double> sparsity;

    private RBMLayerSpace(Builder builder) {
        super(builder);
        this.hiddenUnit = builder.hiddenUnit;
        this.visibleUnit = builder.visibleUnit;
        this.k = builder.k;
        this.sparsity = builder.sparsity;
        this.numParameters = CollectionUtils.countUnique(this.collectLeaves());
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        List<ParameterSpace> list = super.collectLeaves();
        if (this.hiddenUnit != null) {
            list.addAll(this.hiddenUnit.collectLeaves());
        }
        if (this.visibleUnit != null) {
            list.addAll(this.visibleUnit.collectLeaves());
        }
        if (this.k != null) {
            list.addAll(this.k.collectLeaves());
        }
        if (this.sparsity != null) {
            list.addAll(this.sparsity.collectLeaves());
        }
        return list;
    }

    public RBM getValue(double[] values) {
        RBM.Builder b = new RBM.Builder();
        this.setLayerOptionsBuilder(b, values);
        return b.build();
    }

    protected void setLayerOptionsBuilder(RBM.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((FeedForwardLayer.Builder)builder, values);
        if (this.hiddenUnit != null) {
            builder.hiddenUnit((RBM.HiddenUnit)this.hiddenUnit.getValue(values));
        }
        if (this.visibleUnit != null) {
            builder.visibleUnit((RBM.VisibleUnit)this.visibleUnit.getValue(values));
        }
        if (this.k != null) {
            builder.k(((Integer)this.k.getValue(values)).intValue());
        }
        if (this.sparsity != null) {
            builder.sparsity(((Double)this.sparsity.getValue(values)).doubleValue());
        }
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    public String toString(String delim) {
        StringBuilder sb = new StringBuilder("RBMLayerSpace(");
        if (this.hiddenUnit != null) {
            sb.append("hiddenUnit: ").append(this.hiddenUnit).append(delim);
        }
        if (this.visibleUnit != null) {
            sb.append("visibleUnit: ").append(this.visibleUnit).append(delim);
        }
        if (this.k != null) {
            sb.append("k: ").append(this.k).append(delim);
        }
        if (this.sparsity != null) {
            sb.append("sparsity: ").append(this.sparsity).append(delim);
        }
        sb.append(super.toString(delim)).append(")");
        return sb.toString();
    }

    public static class Builder
    extends BasePretrainNetworkLayerSpace.Builder<Builder> {
        private ParameterSpace<RBM.HiddenUnit> hiddenUnit;
        private ParameterSpace<RBM.VisibleUnit> visibleUnit;
        private ParameterSpace<Integer> k;
        private ParameterSpace<Double> sparsity;

        public Builder hiddenUnit(RBM.HiddenUnit hiddenUnit) {
            return this.hiddenUnit((ParameterSpace<RBM.HiddenUnit>)new FixedValue((Object)hiddenUnit));
        }

        public Builder hiddenUnit(ParameterSpace<RBM.HiddenUnit> hiddenUnit) {
            this.hiddenUnit = hiddenUnit;
            return this;
        }

        public Builder visibleUnit(RBM.VisibleUnit visibleUnit) {
            return this.visibleUnit((ParameterSpace<RBM.VisibleUnit>)new FixedValue((Object)visibleUnit));
        }

        public Builder visibleUnit(ParameterSpace<RBM.VisibleUnit> visibleUnit) {
            this.visibleUnit = visibleUnit;
            return this;
        }

        public Builder k(int k) {
            return this.k((ParameterSpace<Integer>)new FixedValue((Object)k));
        }

        public Builder k(ParameterSpace<Integer> k) {
            this.k = k;
            return this;
        }

        public Builder sparsity(double sparsity) {
            return this.sparsity((ParameterSpace<Double>)new FixedValue((Object)sparsity));
        }

        public Builder sparsity(ParameterSpace<Double> sparsity) {
            this.sparsity = sparsity;
            return this;
        }

        @Override
        public RBMLayerSpace build() {
            return new RBMLayerSpace(this);
        }
    }
}

