/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.scoring.graph;

import java.util.Map;
import org.deeplearning4j.arbiter.optimize.api.data.DataProvider;
import org.deeplearning4j.arbiter.optimize.api.score.ScoreFunction;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;

public class GraphTestSetLossScoreFunction
implements ScoreFunction<ComputationGraph, MultiDataSetIterator> {
    private final boolean average;

    public GraphTestSetLossScoreFunction() {
        this(false);
    }

    public GraphTestSetLossScoreFunction(boolean average) {
        this.average = average;
    }

    public double score(ComputationGraph model, DataProvider<MultiDataSetIterator> dataProvider, Map<String, Object> dataParameters) {
        MultiDataSetIterator testData = (MultiDataSetIterator)dataProvider.testData(dataParameters);
        double sumScore = 0.0;
        int totalExamples = 0;
        while (testData.hasNext()) {
            MultiDataSet ds = (MultiDataSet)testData.next();
            int numExamples = ds.getFeatures(0).size(0);
            sumScore += (double)numExamples * model.score(ds);
            totalExamples += numExamples;
        }
        if (!this.average) {
            return sumScore;
        }
        return sumScore / (double)totalExamples;
    }

    public boolean minimize() {
        return true;
    }

    public String toString() {
        return "GraphTestSetLossScoreFunctionDataSet()";
    }
}

