/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.SizeTPointer;
import org.bytedeco.javacpp.cuda;
import org.bytedeco.javacpp.cudnn;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.convolution.ConvolutionHelper;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.convolution.Convolution;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.jcublas.context.CudaContext;

public class CudnnConvolutionHelper
implements ConvolutionHelper {
    CudnnContext cudnnContext = new CudnnContext();
    WorkSpace workSpace = new WorkSpace();
    int dataType = Nd4j.dataType() == DataBuffer.Type.DOUBLE ? 1 : 0;
    int tensorFormat = 0;
    FloatPointer alpha = new FloatPointer(new float[]{1.0f});
    FloatPointer beta = new FloatPointer(new float[]{0.0f});
    SizeTPointer sizeInBytes = new SizeTPointer(1L);

    static void checkCuda(int error) {
        if (error != 0) {
            throw new RuntimeException("CUDA error = " + error);
        }
    }

    static void checkCudnn(int status) {
        if (status != 0) {
            throw new RuntimeException("cuDNN status = " + status);
        }
    }

    public Pair<Gradient, INDArray> backpropGradient(INDArray input, INDArray weights, INDArray delta, int[] kernel, int[] strides, int[] pad, INDArray biasGradView, INDArray weightGradView, String afn) {
        int miniBatch = input.size(0);
        int inH = input.size(2);
        int inW = input.size(3);
        int outDepth = weights.size(0);
        int inDepth = weights.size(1);
        int kH = weights.size(2);
        int kW = weights.size(3);
        int outH = Convolution.outSize((int)inH, (int)kernel[0], (int)strides[0], (int)pad[0], (boolean)false);
        int outW = Convolution.outSize((int)inW, (int)kernel[1], (int)strides[1], (int)pad[1], (boolean)false);
        if (!Shape.strideDescendingCAscendingF((INDArray)delta)) {
            delta = delta.dup();
        }
        int[] srcStride = input.stride();
        int[] deltaStride = delta.stride();
        int[] algo = new int[1];
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnSetTensor4dDescriptorEx((cudnn.cudnnTensorStruct)this.cudnnContext.srcTensorDesc, (int)this.dataType, (int)miniBatch, (int)inDepth, (int)inH, (int)inW, (int)srcStride[0], (int)srcStride[1], (int)srcStride[2], (int)srcStride[3]));
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnSetTensor4dDescriptorEx((cudnn.cudnnTensorStruct)this.cudnnContext.deltaTensorDesc, (int)this.dataType, (int)miniBatch, (int)outDepth, (int)outH, (int)outW, (int)deltaStride[0], (int)deltaStride[1], (int)deltaStride[2], (int)deltaStride[3]));
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnSetConvolution2dDescriptor((cudnn.cudnnConvolutionStruct)this.cudnnContext.convDesc, (int)pad[0], (int)pad[1], (int)strides[0], (int)strides[1], (int)1, (int)1, (int)1));
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnSetFilter4dDescriptor((cudnn.cudnnFilterStruct)this.cudnnContext.filterDesc, (int)this.dataType, (int)this.tensorFormat, (int)outDepth, (int)inDepth, (int)kH, (int)kW));
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnGetConvolutionBackwardFilterAlgorithm((cudnn.cudnnContext)this.cudnnContext, (cudnn.cudnnTensorStruct)this.cudnnContext.srcTensorDesc, (cudnn.cudnnTensorStruct)this.cudnnContext.deltaTensorDesc, (cudnn.cudnnConvolutionStruct)this.cudnnContext.convDesc, (cudnn.cudnnFilterStruct)this.cudnnContext.filterDesc, (int)1, (long)0L, (int[])algo));
        INDArray epsNext = Nd4j.create((int[])new int[]{miniBatch, inDepth, inH, inW}, (char)'c');
        int[] dstStride = epsNext.stride();
        AtomicAllocator allocator = AtomicAllocator.getInstance();
        CudaContext context = allocator.getFlowController().prepareAction(input, new INDArray[]{weights, weightGradView, biasGradView, delta, epsNext});
        Pointer srcData = allocator.getPointer(input, context);
        Pointer filterData = allocator.getPointer(weights, context);
        Pointer filterGradData = allocator.getPointer(weightGradView, context);
        Pointer biasGradData = allocator.getPointer(biasGradView, context);
        Pointer deltaData = allocator.getPointer(delta, context);
        Pointer dstData = allocator.getPointer(epsNext, context);
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnSetStream((cudnn.cudnnContext)this.cudnnContext, (cuda.CUstream_st)new cuda.CUstream_st((Pointer)context.getOldStream())));
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnSetTensor4dDescriptorEx((cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (int)this.dataType, (int)miniBatch, (int)inDepth, (int)inH, (int)inW, (int)dstStride[0], (int)dstStride[1], (int)dstStride[2], (int)dstStride[3]));
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnGetConvolutionBackwardFilterWorkspaceSize((cudnn.cudnnContext)this.cudnnContext, (cudnn.cudnnTensorStruct)this.cudnnContext.srcTensorDesc, (cudnn.cudnnTensorStruct)this.cudnnContext.deltaTensorDesc, (cudnn.cudnnConvolutionStruct)this.cudnnContext.convDesc, (cudnn.cudnnFilterStruct)this.cudnnContext.filterDesc, (int)algo[0], (SizeTPointer)this.sizeInBytes));
        long sizeInBytes1 = this.sizeInBytes.get(0L);
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnGetConvolutionBackwardDataWorkspaceSize((cudnn.cudnnContext)this.cudnnContext, (cudnn.cudnnFilterStruct)this.cudnnContext.filterDesc, (cudnn.cudnnTensorStruct)this.cudnnContext.deltaTensorDesc, (cudnn.cudnnConvolutionStruct)this.cudnnContext.convDesc, (cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (int)algo[0], (SizeTPointer)this.sizeInBytes));
        long sizeInBytes2 = this.sizeInBytes.get(0L);
        if (sizeInBytes1 > this.workSpace.capacity() || sizeInBytes2 > this.workSpace.capacity()) {
            this.workSpace.deallocate();
            this.workSpace = new WorkSpace(Math.max(sizeInBytes1, sizeInBytes2));
        }
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnSetTensor4dDescriptor((cudnn.cudnnTensorStruct)this.cudnnContext.biasTensorDesc, (int)this.tensorFormat, (int)this.dataType, (int)1, (int)outDepth, (int)1, (int)1));
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnConvolutionBackwardBias((cudnn.cudnnContext)this.cudnnContext, (Pointer)this.alpha, (cudnn.cudnnTensorStruct)this.cudnnContext.deltaTensorDesc, (Pointer)deltaData, (Pointer)this.beta, (cudnn.cudnnTensorStruct)this.cudnnContext.biasTensorDesc, (Pointer)biasGradData));
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnConvolutionBackwardFilter((cudnn.cudnnContext)this.cudnnContext, (Pointer)this.alpha, (cudnn.cudnnTensorStruct)this.cudnnContext.srcTensorDesc, (Pointer)srcData, (cudnn.cudnnTensorStruct)this.cudnnContext.deltaTensorDesc, (Pointer)deltaData, (cudnn.cudnnConvolutionStruct)this.cudnnContext.convDesc, (int)algo[0], (Pointer)this.workSpace, (long)this.workSpace.capacity(), (Pointer)this.beta, (cudnn.cudnnFilterStruct)this.cudnnContext.filterDesc, (Pointer)filterGradData));
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnConvolutionBackwardData((cudnn.cudnnContext)this.cudnnContext, (Pointer)this.alpha, (cudnn.cudnnFilterStruct)this.cudnnContext.filterDesc, (Pointer)filterData, (cudnn.cudnnTensorStruct)this.cudnnContext.deltaTensorDesc, (Pointer)deltaData, (cudnn.cudnnConvolutionStruct)this.cudnnContext.convDesc, (int)algo[0], (Pointer)this.workSpace, (long)this.workSpace.capacity(), (Pointer)this.beta, (cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (Pointer)dstData));
        allocator.registerAction(context, input, new INDArray[]{weights, weightGradView, biasGradView, delta, epsNext});
        DefaultGradient retGradient = new DefaultGradient();
        retGradient.setGradientFor("b", biasGradView);
        retGradient.setGradientFor("W", weightGradView, Character.valueOf('c'));
        return new Pair((Object)retGradient, (Object)epsNext);
    }

    public INDArray preOutput(INDArray input, INDArray weights, INDArray bias, int[] kernel, int[] strides, int[] pad) {
        int miniBatch = input.size(0);
        int inH = input.size(2);
        int inW = input.size(3);
        int outDepth = weights.size(0);
        int inDepth = weights.size(1);
        int kH = weights.size(2);
        int kW = weights.size(3);
        int[] srcStride = input.stride();
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnSetTensor4dDescriptorEx((cudnn.cudnnTensorStruct)this.cudnnContext.srcTensorDesc, (int)this.dataType, (int)miniBatch, (int)inDepth, (int)inH, (int)inW, (int)srcStride[0], (int)srcStride[1], (int)srcStride[2], (int)srcStride[3]));
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnSetFilter4dDescriptor((cudnn.cudnnFilterStruct)this.cudnnContext.filterDesc, (int)this.dataType, (int)this.tensorFormat, (int)outDepth, (int)inDepth, (int)kH, (int)kW));
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnSetConvolution2dDescriptor((cudnn.cudnnConvolutionStruct)this.cudnnContext.convDesc, (int)pad[0], (int)pad[1], (int)strides[0], (int)strides[1], (int)1, (int)1, (int)1));
        int[] algo = new int[1];
        int[] n = new int[1];
        int[] c = new int[1];
        int[] h = new int[1];
        int[] w = new int[1];
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnGetConvolution2dForwardOutputDim((cudnn.cudnnConvolutionStruct)this.cudnnContext.convDesc, (cudnn.cudnnTensorStruct)this.cudnnContext.srcTensorDesc, (cudnn.cudnnFilterStruct)this.cudnnContext.filterDesc, (int[])n, (int[])c, (int[])h, (int[])w));
        INDArray z = Nd4j.createUninitialized((int[])new int[]{n[0], c[0], h[0], w[0]}, (char)'c');
        int[] dstStride = z.stride();
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnSetTensor4dDescriptorEx((cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (int)this.dataType, (int)n[0], (int)c[0], (int)h[0], (int)w[0], (int)dstStride[0], (int)dstStride[1], (int)dstStride[2], (int)dstStride[3]));
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnGetConvolutionForwardAlgorithm((cudnn.cudnnContext)this.cudnnContext, (cudnn.cudnnTensorStruct)this.cudnnContext.srcTensorDesc, (cudnn.cudnnFilterStruct)this.cudnnContext.filterDesc, (cudnn.cudnnConvolutionStruct)this.cudnnContext.convDesc, (cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (int)1, (long)0L, (int[])algo));
        AtomicAllocator allocator = AtomicAllocator.getInstance();
        CudaContext context = allocator.getFlowController().prepareAction(input, new INDArray[]{weights, bias, z});
        Pointer srcData = allocator.getPointer(input, context);
        Pointer filterData = allocator.getPointer(weights, context);
        Pointer biasData = allocator.getPointer(bias, context);
        Pointer dstData = allocator.getPointer(z, context);
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnSetStream((cudnn.cudnnContext)this.cudnnContext, (cuda.CUstream_st)new cuda.CUstream_st((Pointer)context.getOldStream())));
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnGetConvolutionForwardWorkspaceSize((cudnn.cudnnContext)this.cudnnContext, (cudnn.cudnnTensorStruct)this.cudnnContext.srcTensorDesc, (cudnn.cudnnFilterStruct)this.cudnnContext.filterDesc, (cudnn.cudnnConvolutionStruct)this.cudnnContext.convDesc, (cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (int)algo[0], (SizeTPointer)this.sizeInBytes));
        if (this.sizeInBytes.get(0L) > this.workSpace.capacity()) {
            this.workSpace.deallocate();
            this.workSpace = new WorkSpace(this.sizeInBytes.get(0L));
        }
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnConvolutionForward((cudnn.cudnnContext)this.cudnnContext, (Pointer)this.alpha, (cudnn.cudnnTensorStruct)this.cudnnContext.srcTensorDesc, (Pointer)srcData, (cudnn.cudnnFilterStruct)this.cudnnContext.filterDesc, (Pointer)filterData, (cudnn.cudnnConvolutionStruct)this.cudnnContext.convDesc, (int)algo[0], (Pointer)this.workSpace, (long)this.workSpace.capacity(), (Pointer)this.beta, (cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (Pointer)dstData));
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnSetTensor4dDescriptor((cudnn.cudnnTensorStruct)this.cudnnContext.biasTensorDesc, (int)this.tensorFormat, (int)this.dataType, (int)1, (int)c[0], (int)1, (int)1));
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnAddTensor((cudnn.cudnnContext)this.cudnnContext, (Pointer)this.alpha, (cudnn.cudnnTensorStruct)this.cudnnContext.biasTensorDesc, (Pointer)biasData, (Pointer)this.alpha, (cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (Pointer)dstData));
        allocator.registerAction(context, input, new INDArray[]{weights, bias, z});
        return z;
    }

    public INDArray activate(INDArray z, String afn) {
        INDArray activation = z;
        AtomicAllocator allocator = AtomicAllocator.getInstance();
        CudaContext context = allocator.getFlowController().prepareAction(z, new INDArray[0]);
        Pointer dstData = allocator.getPointer(z, context);
        CudnnConvolutionHelper.checkCudnn(cudnn.cudnnSetStream((cudnn.cudnnContext)this.cudnnContext, (cuda.CUstream_st)new cuda.CUstream_st((Pointer)context.getOldStream())));
        switch (afn) {
            case "identity": {
                break;
            }
            case "sigmoid": {
                CudnnConvolutionHelper.checkCudnn(cudnn.cudnnSetActivationDescriptor((cudnn.cudnnActivationStruct)this.cudnnContext.activationDesc, (int)0, (int)1, (double)0.0));
                CudnnConvolutionHelper.checkCudnn(cudnn.cudnnActivationForward((cudnn.cudnnContext)this.cudnnContext, (cudnn.cudnnActivationStruct)this.cudnnContext.activationDesc, (Pointer)this.alpha, (cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (Pointer)dstData, (Pointer)this.beta, (cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (Pointer)dstData));
                break;
            }
            case "relu": {
                CudnnConvolutionHelper.checkCudnn(cudnn.cudnnSetActivationDescriptor((cudnn.cudnnActivationStruct)this.cudnnContext.activationDesc, (int)1, (int)1, (double)0.0));
                CudnnConvolutionHelper.checkCudnn(cudnn.cudnnActivationForward((cudnn.cudnnContext)this.cudnnContext, (cudnn.cudnnActivationStruct)this.cudnnContext.activationDesc, (Pointer)this.alpha, (cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (Pointer)dstData, (Pointer)this.beta, (cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (Pointer)dstData));
                break;
            }
            case "tanh": {
                CudnnConvolutionHelper.checkCudnn(cudnn.cudnnSetActivationDescriptor((cudnn.cudnnActivationStruct)this.cudnnContext.activationDesc, (int)2, (int)1, (double)0.0));
                CudnnConvolutionHelper.checkCudnn(cudnn.cudnnActivationForward((cudnn.cudnnContext)this.cudnnContext, (cudnn.cudnnActivationStruct)this.cudnnContext.activationDesc, (Pointer)this.alpha, (cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (Pointer)dstData, (Pointer)this.beta, (cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (Pointer)dstData));
                break;
            }
            case "softmax": {
                CudnnConvolutionHelper.checkCudnn(cudnn.cudnnSoftmaxForward((cudnn.cudnnContext)this.cudnnContext, (int)1, (int)1, (Pointer)this.alpha, (cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (Pointer)dstData, (Pointer)this.beta, (cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (Pointer)dstData));
                break;
            }
            case "logsoftmax": {
                CudnnConvolutionHelper.checkCudnn(cudnn.cudnnSoftmaxForward((cudnn.cudnnContext)this.cudnnContext, (int)2, (int)1, (Pointer)this.alpha, (cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (Pointer)dstData, (Pointer)this.beta, (cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (Pointer)dstData));
                break;
            }
            default: {
                activation = null;
            }
        }
        allocator.registerAction(context, z, new INDArray[0]);
        return activation;
    }

    static class WorkSpace
    extends Pointer {
        WorkSpace() {
        }

        WorkSpace(long size) {
            CudnnConvolutionHelper.checkCuda(cuda.cudaMalloc((Pointer)this, (long)size));
            this.limit = this.capacity = size;
            this.deallocator(new Deallocator(this));
        }

        WorkSpace(WorkSpace w) {
            super((Pointer)w);
        }

        static class Deallocator
        extends WorkSpace
        implements Pointer.Deallocator {
            Deallocator(WorkSpace w) {
                super(w);
            }

            public void deallocate() {
                CudnnConvolutionHelper.checkCuda(cuda.cudaFree((Pointer)this));
                this.setNull();
            }
        }
    }

    static class CudnnContext
    extends cudnn.cudnnContext {
        cudnn.cudnnTensorStruct srcTensorDesc = new cudnn.cudnnTensorStruct();
        cudnn.cudnnTensorStruct dstTensorDesc = new cudnn.cudnnTensorStruct();
        cudnn.cudnnTensorStruct biasTensorDesc = new cudnn.cudnnTensorStruct();
        cudnn.cudnnTensorStruct deltaTensorDesc = new cudnn.cudnnTensorStruct();
        cudnn.cudnnFilterStruct filterDesc = new cudnn.cudnnFilterStruct();
        cudnn.cudnnConvolutionStruct convDesc = new cudnn.cudnnConvolutionStruct();
        cudnn.cudnnActivationStruct activationDesc = new cudnn.cudnnActivationStruct();

        CudnnContext() {
            this.createHandles();
            this.deallocator(new Deallocator(this));
        }

        CudnnContext(CudnnContext c) {
            super((Pointer)c);
            this.srcTensorDesc = new cudnn.cudnnTensorStruct((Pointer)c.srcTensorDesc);
            this.dstTensorDesc = new cudnn.cudnnTensorStruct((Pointer)c.dstTensorDesc);
            this.biasTensorDesc = new cudnn.cudnnTensorStruct((Pointer)c.biasTensorDesc);
            this.deltaTensorDesc = new cudnn.cudnnTensorStruct((Pointer)c.deltaTensorDesc);
            this.filterDesc = new cudnn.cudnnFilterStruct((Pointer)c.filterDesc);
            this.convDesc = new cudnn.cudnnConvolutionStruct((Pointer)c.convDesc);
            this.activationDesc = new cudnn.cudnnActivationStruct((Pointer)c.activationDesc);
        }

        void createHandles() {
            CudnnConvolutionHelper.checkCudnn(cudnn.cudnnCreate((cudnn.cudnnContext)this));
            CudnnConvolutionHelper.checkCudnn(cudnn.cudnnCreateTensorDescriptor((cudnn.cudnnTensorStruct)this.srcTensorDesc));
            CudnnConvolutionHelper.checkCudnn(cudnn.cudnnCreateTensorDescriptor((cudnn.cudnnTensorStruct)this.dstTensorDesc));
            CudnnConvolutionHelper.checkCudnn(cudnn.cudnnCreateTensorDescriptor((cudnn.cudnnTensorStruct)this.biasTensorDesc));
            CudnnConvolutionHelper.checkCudnn(cudnn.cudnnCreateTensorDescriptor((cudnn.cudnnTensorStruct)this.deltaTensorDesc));
            CudnnConvolutionHelper.checkCudnn(cudnn.cudnnCreateFilterDescriptor((cudnn.cudnnFilterStruct)this.filterDesc));
            CudnnConvolutionHelper.checkCudnn(cudnn.cudnnCreateConvolutionDescriptor((cudnn.cudnnConvolutionStruct)this.convDesc));
            CudnnConvolutionHelper.checkCudnn(cudnn.cudnnCreateActivationDescriptor((cudnn.cudnnActivationStruct)this.activationDesc));
        }

        void destroyHandles() {
            CudnnConvolutionHelper.checkCudnn(cudnn.cudnnDestroyActivationDescriptor((cudnn.cudnnActivationStruct)this.activationDesc));
            CudnnConvolutionHelper.checkCudnn(cudnn.cudnnDestroyConvolutionDescriptor((cudnn.cudnnConvolutionStruct)this.convDesc));
            CudnnConvolutionHelper.checkCudnn(cudnn.cudnnDestroyFilterDescriptor((cudnn.cudnnFilterStruct)this.filterDesc));
            CudnnConvolutionHelper.checkCudnn(cudnn.cudnnDestroyTensorDescriptor((cudnn.cudnnTensorStruct)this.srcTensorDesc));
            CudnnConvolutionHelper.checkCudnn(cudnn.cudnnDestroyTensorDescriptor((cudnn.cudnnTensorStruct)this.dstTensorDesc));
            CudnnConvolutionHelper.checkCudnn(cudnn.cudnnDestroyTensorDescriptor((cudnn.cudnnTensorStruct)this.biasTensorDesc));
            CudnnConvolutionHelper.checkCudnn(cudnn.cudnnDestroyTensorDescriptor((cudnn.cudnnTensorStruct)this.deltaTensorDesc));
            CudnnConvolutionHelper.checkCudnn(cudnn.cudnnDestroy((cudnn.cudnnContext)this));
        }

        static class Deallocator
        extends CudnnContext
        implements Pointer.Deallocator {
            Deallocator(CudnnContext c) {
                super(c);
            }

            public void deallocate() {
                this.destroyHandles();
            }
        }
    }
}

