/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.glove.count;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.deeplearning4j.models.glove.count.CoOccurenceReader;
import org.deeplearning4j.models.glove.count.CoOccurrenceWeight;
import org.deeplearning4j.models.glove.count.CountMap;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryCoOccurrenceReader<T extends SequenceElement>
implements CoOccurenceReader<T> {
    private VocabCache<T> vocabCache;
    private InputStream inputStream;
    private File file;
    private ArrayBlockingQueue<CoOccurrenceWeight<T>> buffer;
    int workers = Math.max(Runtime.getRuntime().availableProcessors() - 1, 1);
    private StreamReaderThread readerThread;
    private CountMap<T> countMap;
    protected static final Logger logger = LoggerFactory.getLogger(BinaryCoOccurrenceReader.class);

    public BinaryCoOccurrenceReader(@NonNull File file, @NonNull VocabCache<T> vocabCache, CountMap<T> map) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache");
        }
        this.vocabCache = vocabCache;
        this.file = file;
        this.countMap = map;
        this.buffer = new ArrayBlockingQueue(200000);
        try {
            this.inputStream = new BufferedInputStream(new FileInputStream(this.file), 0x6400000);
            this.readerThread = new StreamReaderThread(this.inputStream);
            this.readerThread.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasMoreObjects() {
        if (this.buffer.size() > 0) {
            return true;
        }
        try {
            return this.readerThread.hasMoreObjects() || this.buffer.size() > 0;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CoOccurrenceWeight<T> nextObject() {
        if (this.buffer.size() > 0) {
            return this.buffer.poll();
        }
        if (this.readerThread.hasMoreObjects()) {
            try {
                return this.buffer.poll(3L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void finish() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class AsyncDeserializationThread
    extends Thread
    implements Runnable {
        private int threadId;
        private byte[] arrayReference;
        private ArrayBlockingQueue<CoOccurrenceWeight<T>> targetBuffer;
        private AtomicInteger pointer;
        private int limit;

        public AsyncDeserializationThread(@NonNull int threadId, @NonNull byte[] array, @NonNull ArrayBlockingQueue<CoOccurrenceWeight<T>> targetBuffer, AtomicInteger sharedPointer, int limit) {
            if (array == null) {
                throw new NullPointerException("array");
            }
            if (targetBuffer == null) {
                throw new NullPointerException("targetBuffer");
            }
            if (sharedPointer == null) {
                throw new NullPointerException("sharedPointer");
            }
            this.threadId = threadId;
            this.arrayReference = array;
            this.targetBuffer = targetBuffer;
            this.pointer = sharedPointer;
            this.limit = limit;
            this.setName("AsynDeserialization thread " + this.threadId);
        }

        @Override
        public void run() {
            ByteBuffer bB = ByteBuffer.wrap(this.arrayReference);
            int position = 0;
            while ((position = this.pointer.getAndAdd(16)) < this.limit) {
                double mW;
                if (position >= this.limit) continue;
                int e1idx = bB.getInt(position);
                int e2idx = bB.getInt(position + 4);
                double eW = bB.getDouble(position + 8);
                CoOccurrenceWeight object = new CoOccurrenceWeight();
                object.setElement1(BinaryCoOccurrenceReader.this.vocabCache.elementAtIndex(e1idx));
                object.setElement2(BinaryCoOccurrenceReader.this.vocabCache.elementAtIndex(e2idx));
                if (BinaryCoOccurrenceReader.this.countMap != null && (mW = BinaryCoOccurrenceReader.this.countMap.getCount(object.getElement1(), object.getElement2())) > 0.0) {
                    eW += mW;
                    BinaryCoOccurrenceReader.this.countMap.removePair(object.getElement1(), object.getElement2());
                }
                object.setWeight(eW);
                try {
                    this.targetBuffer.put(object);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private class StreamReaderThread
    extends Thread
    implements Runnable {
        private InputStream stream;
        private AtomicBoolean isReading = new AtomicBoolean(false);

        public StreamReaderThread(InputStream stream) {
            if (stream == null) {
                throw new NullPointerException("stream");
            }
            this.stream = stream;
            this.isReading.set(false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                int count;
                byte[] array = new byte[8000000];
                do {
                    int t;
                    count = this.stream.read(array);
                    this.isReading.set(true);
                    if (count == 0) return;
                    ArrayList<AsyncDeserializationThread> threads = new ArrayList<AsyncDeserializationThread>();
                    AtomicInteger internalPosition = new AtomicInteger(0);
                    for (t = 0; t < BinaryCoOccurrenceReader.this.workers; ++t) {
                        threads.add(t, new AsyncDeserializationThread(t, array, BinaryCoOccurrenceReader.this.buffer, internalPosition, count));
                        ((AsyncDeserializationThread)threads.get(t)).start();
                    }
                    for (t = 0; t < BinaryCoOccurrenceReader.this.workers; ++t) {
                        try {
                            ((AsyncDeserializationThread)threads.get(t)).join();
                            continue;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    this.isReading.set(false);
                } while (count >= array.length);
                return;
            }
            catch (Exception e) {
                this.isReading.set(false);
                throw new RuntimeException(e);
            }
        }

        public boolean hasMoreObjects() {
            try {
                boolean bl = this.stream.available() > 0 || this.isReading.get();
                return bl;
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
        }
    }
}

