/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.glove.count;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import lombok.NonNull;
import org.deeplearning4j.models.glove.count.CoOccurrenceWeight;
import org.deeplearning4j.models.glove.count.CoOccurrenceWriter;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryCoOccurrenceWriter<T extends SequenceElement>
implements CoOccurrenceWriter<T> {
    private File file;
    private DataOutputStream outputStream;
    private static final Logger log = LoggerFactory.getLogger(BinaryCoOccurrenceWriter.class);

    public BinaryCoOccurrenceWriter(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.file = file;
        try {
            this.outputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file), 0x6400000));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeObject(@NonNull CoOccurrenceWeight<T> object) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        try {
            this.outputStream.writeInt(((SequenceElement)object.getElement1()).getIndex());
            this.outputStream.writeInt(((SequenceElement)object.getElement2()).getIndex());
            this.outputStream.writeDouble(object.getWeight());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void queueObject(CoOccurrenceWeight<T> object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void finish() {
        try {
            this.outputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

