/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.corpora.treeparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.fit.util.FSCollectionFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.syntax.constituent.type.TreebankNode;
import org.cleartk.syntax.constituent.type.TreebankNodeUtil;
import org.cleartk.token.type.Token;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.layers.feedforward.autoencoder.recursive.Tree;
import org.deeplearning4j.util.MultiDimensionalMap;

public class TreeFactory {
    public static Tree buildTree(TreebankNode node, Pair<String, MultiDimensionalMap<Integer, Integer, String>> labels, List<String> possibleLabels) throws Exception {
        if (node.getLeaf()) {
            return TreeFactory.toTree(node);
        }
        List<TreebankNode> preChildren = TreeFactory.children(node);
        ArrayList<Tree> children = new ArrayList<Tree>();
        Tree t = TreeFactory.toTree(node);
        for (Pair interval : ((MultiDimensionalMap)labels.getSecond()).keySet()) {
            if (!TreeFactory.inRange((Integer)interval.getFirst(), (Integer)interval.getSecond(), t)) continue;
            t.setGoldLabel(possibleLabels.indexOf(((MultiDimensionalMap)labels.getSecond()).get(interval.getFirst(), interval.getSecond())));
            break;
        }
        for (int i = 0; i < preChildren.size(); ++i) {
            children.add(TreeFactory.buildTree(preChildren.get(i)));
        }
        t.connect(children);
        return t;
    }

    public static Tree toTree(TreebankNode node, Pair<String, MultiDimensionalMap<Integer, Integer, String>> labels) throws Exception {
        List<String> tokens = TreeFactory.tokens((Annotation)node);
        Tree ret = new Tree(tokens);
        ret.setValue(node.getNodeValue());
        ret.setLabel(node.getNodeType());
        ret.setType(node.getNodeType());
        ret.setBegin(node.getBegin());
        ret.setEnd(node.getEnd());
        ret.setParse(TreebankNodeUtil.toTreebankString((TreebankNode)node));
        if (node.getNodeTags() != null) {
            ret.setTags(TreeFactory.tags(node));
        } else {
            ret.setTags(Arrays.asList(node.getNodeType()));
        }
        return ret;
    }

    public static Tree buildTree(TreebankNode node) throws Exception {
        if (node.getLeaf()) {
            return TreeFactory.toTree(node);
        }
        List<TreebankNode> preChildren = TreeFactory.children(node);
        ArrayList<Tree> children = new ArrayList<Tree>();
        Tree t = TreeFactory.toTree(node);
        for (int i = 0; i < preChildren.size(); ++i) {
            children.add(TreeFactory.buildTree(preChildren.get(i)));
        }
        t.connect(children);
        return t;
    }

    public static Tree toTree(TreebankNode node) throws Exception {
        List<String> tokens = TreeFactory.tokens((Annotation)node);
        Tree ret = new Tree(tokens);
        ret.setValue(node.getNodeValue());
        ret.setLabel(node.getNodeType());
        ret.setType(node.getNodeType());
        ret.setBegin(node.getBegin());
        ret.setEnd(node.getEnd());
        ret.setParse(TreebankNodeUtil.toTreebankString((TreebankNode)node));
        if (node.getNodeTags() != null) {
            ret.setTags(TreeFactory.tags(node));
        } else {
            ret.setTags(Arrays.asList(node.getNodeType()));
        }
        return ret;
    }

    private static List<String> tags(TreebankNode node) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < node.getNodeTags().size(); ++i) {
            ret.add(node.getNodeTags(i));
        }
        return ret;
    }

    private static List<TreebankNode> children(TreebankNode node) {
        return new ArrayList<TreebankNode>(FSCollectionFactory.create((ArrayFS)node.getChildren(), TreebankNode.class));
    }

    private static List<String> tokens(Annotation ann) throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        for (Token t : JCasUtil.select((JCas)ann.getCAS().getJCas(), Token.class)) {
            ret.add(t.getCoveredText());
        }
        return ret;
    }

    private static boolean inRange(int begin, int end, Tree tree) {
        return tree.getBegin() >= begin && tree.getEnd() <= end;
    }
}

