/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.sentenceiterator.interoperability;

import lombok.NonNull;
import org.deeplearning4j.text.documentiterator.LabelAwareIterator;
import org.deeplearning4j.text.documentiterator.LabelledDocument;
import org.deeplearning4j.text.documentiterator.LabelsSource;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;
import org.deeplearning4j.text.sentenceiterator.labelaware.LabelAwareSentenceIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentenceIteratorConverter
implements LabelAwareIterator {
    private SentenceIterator backendIterator;
    private LabelsSource generator;
    protected static final Logger log = LoggerFactory.getLogger(SentenceIteratorConverter.class);

    public SentenceIteratorConverter(@NonNull SentenceIterator iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        this.backendIterator = iterator;
        this.generator = new LabelsSource();
    }

    public SentenceIteratorConverter(@NonNull SentenceIterator iterator, @NonNull LabelsSource generator) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        if (generator == null) {
            throw new NullPointerException("generator");
        }
        this.backendIterator = iterator;
        this.generator = generator;
    }

    @Override
    public boolean hasNextDocument() {
        return this.backendIterator.hasNext();
    }

    @Override
    public LabelledDocument nextDocument() {
        LabelledDocument document = new LabelledDocument();
        document.setContent(this.backendIterator.nextSentence());
        if (this.backendIterator instanceof LabelAwareSentenceIterator) {
            String currentLabel = ((LabelAwareSentenceIterator)this.backendIterator).currentLabel();
            document.setLabel(currentLabel);
            this.generator.storeLabel(currentLabel);
        } else if (this.generator != null) {
            document.setLabel(this.generator.nextLabel());
        }
        return document;
    }

    @Override
    public void reset() {
        this.generator.reset();
        this.backendIterator.reset();
    }

    @Override
    public LabelsSource getLabelsSource() {
        return this.generator;
    }
}

