/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.documentiterator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.deeplearning4j.text.documentiterator.DocumentIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDocumentIterator
implements DocumentIterator {
    private Iterator<File> iter;
    private LineIterator lineIterator;
    private File rootDir;
    private static final Logger log = LoggerFactory.getLogger(FileDocumentIterator.class);

    public FileDocumentIterator(String path) {
        this(new File(path));
    }

    public FileDocumentIterator(File path) {
        if (path.isFile()) {
            this.iter = Arrays.asList(path).iterator();
            try {
                this.lineIterator = FileUtils.lineIterator((File)path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.rootDir = path;
        } else {
            this.iter = FileUtils.iterateFiles((File)path, null, (boolean)true);
            try {
                this.lineIterator = FileUtils.lineIterator((File)this.iter.next());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.rootDir = path;
        }
    }

    @Override
    public synchronized InputStream nextDocument() {
        try {
            if (this.lineIterator != null && !this.lineIterator.hasNext() && this.iter.hasNext()) {
                File next = this.iter.next();
                this.lineIterator.close();
                this.lineIterator = FileUtils.lineIterator((File)next);
                while (!this.lineIterator.hasNext()) {
                    this.lineIterator.close();
                    this.lineIterator = FileUtils.lineIterator((File)next);
                }
            }
            if (this.lineIterator != null && this.lineIterator.hasNext()) {
                return new BufferedInputStream(IOUtils.toInputStream((String)this.lineIterator.nextLine()));
            }
        }
        catch (Exception e) {
            log.warn("Error reading input stream...this is just a warning..Going to return", (Throwable)e);
            return null;
        }
        return null;
    }

    @Override
    public synchronized boolean hasNext() {
        return this.iter.hasNext() || this.lineIterator != null && this.lineIterator.hasNext();
    }

    @Override
    public void reset() {
        this.iter = this.rootDir.isDirectory() ? FileUtils.iterateFiles((File)this.rootDir, null, (boolean)true) : Arrays.asList(this.rootDir).iterator();
    }
}

