/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.ml.feature;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.spark.ml.UnaryTransformer;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.canova.image.loader.ImageLoader;
import org.deeplearning4j.spark.ml.util.Identifiable$;
import org.deeplearning4j.spark.sql.types.VectorUDT$;
import org.deeplearning4j.spark.util.package$conversions$;
import org.nd4j.linalg.api.ndarray.INDArray;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}4A!\u0001\u0002\u0001\u001b\ty\u0011*\\1hKZ+7\r^8sSj,'O\u0003\u0002\u0004\t\u00059a-Z1ukJ,'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u000fI\u0016,\u0007\u000f\\3be:Lgn\u001a\u001bk\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0001\u0001\u000f!\u0015yACF\u0010(\u001b\u0005\u0001\"BA\u0003\u0012\u0015\t9!C\u0003\u0002\u0014\u0015\u00051\u0011\r]1dQ\u0016L!!\u0006\t\u0003!Us\u0017M]=Ue\u0006t7OZ8s[\u0016\u0014\bcA\f\u001b95\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0018;%\u0011a\u0004\u0007\u0002\u0005\u0005f$X\r\u0005\u0002!K5\t\u0011E\u0003\u0002#G\u00051A.\u001b8bY\u001eT!\u0001J\t\u0002\u000b5dG.\u001b2\n\u0005\u0019\n#A\u0002,fGR|'\u000f\u0005\u0002)\u00015\t!\u0001\u0003\u0005+\u0001\t\u0015\r\u0011\"\u0011,\u0003\r)\u0018\u000eZ\u000b\u0002YA\u0011Q\u0006\r\b\u0003/9J!a\f\r\u0002\rA\u0013X\rZ3g\u0013\t\t$G\u0001\u0004TiJLgn\u001a\u0006\u0003_aA\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\u0005k&$\u0007\u0005C\u00037\u0001\u0011\u0005q'\u0001\u0004=S:LGO\u0010\u000b\u0003OaBQAK\u001bA\u00021BQA\u000e\u0001\u0005\u0002i\"\u0012a\n\u0005\by\u0001\u0011\r\u0011\"\u0001>\u0003\u0019AW-[4iiV\ta\bE\u0002@\u0005\u0012k\u0011\u0001\u0011\u0006\u0003\u0003B\tQ\u0001]1sC6L!a\u0011!\u0003\u000bA\u000b'/Y7\u0011\u0005])\u0015B\u0001$\u0019\u0005\rIe\u000e\u001e\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002 \u0002\u000f!,\u0017n\u001a5uA!9!\n\u0001b\u0001\n\u0003i\u0014!B<jIRD\u0007B\u0002'\u0001A\u0003%a(\u0001\u0004xS\u0012$\b\u000e\t\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001>\u0003!\u0019\u0007.\u00198oK2\u001c\bB\u0002)\u0001A\u0003%a(A\u0005dQ\u0006tg.\u001a7tA!)!\u000b\u0001C\u0001'\u0006I1/\u001a;IK&<\u0007\u000e\u001e\u000b\u0003)Vk\u0011\u0001\u0001\u0005\u0006-F\u0003\r\u0001R\u0001\u0006m\u0006dW/\u001a\u0005\u00061\u0002!\t!W\u0001\tg\u0016$x+\u001b3uQR\u0011AK\u0017\u0005\u0006-^\u0003\r\u0001\u0012\u0005\u00069\u0002!\t!X\u0001\fg\u0016$8\t[1o]\u0016d7\u000f\u0006\u0002U=\")ak\u0017a\u0001\t\")\u0001\r\u0001C\u0001C\u0006Iq-\u001a;IK&<\u0007\u000e^\u000b\u0002\t\")1\r\u0001C\u0001C\u0006Aq-\u001a;XS\u0012$\b\u000eC\u0003f\u0001\u0011\u0005\u0011-A\u0006hKR\u001c\u0005.\u00198oK2\u001c\b\"B4\u0001\t#B\u0017aE2sK\u0006$X\r\u0016:b]N4wN]7Gk:\u001cW#A5\u0011\t]QgcH\u0005\u0003Wb\u0011\u0011BR;oGRLwN\\\u0019\t\u000b5\u0004A\u0011\u000b8\u0002#Y\fG.\u001b3bi\u0016Le\u000e];u)f\u0004X\r\u0006\u0002peB\u0011q\u0003]\u0005\u0003cb\u0011A!\u00168ji\")1\u000f\u001ca\u0001i\u0006I\u0011N\u001c9viRK\b/\u001a\t\u0003kjl\u0011A\u001e\u0006\u0003ob\fQ\u0001^=qKNT!!_\t\u0002\u0007M\fH.\u0003\u0002|m\nAA)\u0019;b)f\u0004X\rC\u0003~\u0001\u0011Ec0\u0001\bpkR\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3\u0016\u0003Q\u0004")
public class ImageVectorizer
extends UnaryTransformer<byte[], Vector, ImageVectorizer> {
    private final String uid;
    private final Param<Object> height;
    private final Param<Object> width;
    private final Param<Object> channels;

    public String uid() {
        return this.uid;
    }

    public Param<Object> height() {
        return this.height;
    }

    public Param<Object> width() {
        return this.width;
    }

    public Param<Object> channels() {
        return this.channels;
    }

    public ImageVectorizer setHeight(int value) {
        return (ImageVectorizer)this.set(this.height(), BoxesRunTime.boxToInteger((int)value));
    }

    public ImageVectorizer setWidth(int value) {
        return (ImageVectorizer)this.set(this.width(), BoxesRunTime.boxToInteger((int)value));
    }

    public ImageVectorizer setChannels(int value) {
        return (ImageVectorizer)this.set(this.channels(), BoxesRunTime.boxToInteger((int)value));
    }

    public int getHeight() {
        return BoxesRunTime.unboxToInt((Object)this.$(this.height()));
    }

    public int getWidth() {
        return BoxesRunTime.unboxToInt((Object)this.$(this.width()));
    }

    public int getChannels() {
        return BoxesRunTime.unboxToInt((Object)this.$(this.channels()));
    }

    public Function1<byte[], Vector> createTransformFunc() {
        ImageLoader imageLoader = new ImageLoader(BoxesRunTime.unboxToInt((Object)this.$(this.height())), BoxesRunTime.unboxToInt((Object)this.$(this.width())), BoxesRunTime.unboxToInt((Object)this.$(this.channels())));
        return new Serializable(this, imageLoader){
            public static final long serialVersionUID = 0L;
            private final ImageLoader imageLoader$1;

            public final Vector apply(byte[] content) {
                ByteArrayInputStream imgStream = new ByteArrayInputStream(content);
                INDArray vector = this.imageLoader$1.asRowVector((InputStream)imgStream);
                Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)vector.length()));
                return package$conversions$.MODULE$.toVector(vector);
            }
            {
                this.imageLoader$1 = imageLoader$1;
            }
        };
    }

    public void validateInputType(DataType inputType) {
        DataType dataType = inputType;
        BinaryType$ binaryType$ = BinaryType$.MODULE$;
        Predef$.MODULE$.require(!(dataType != null ? !dataType.equals(binaryType$) : binaryType$ != null), (Function0)new Serializable(this, inputType){
            public static final long serialVersionUID = 0L;
            private final DataType inputType$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input type must be BinaryType but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.inputType$1}));
            }
            {
                this.inputType$1 = inputType$1;
            }
        });
    }

    public DataType outputDataType() {
        return VectorUDT$.MODULE$.apply();
    }

    public ImageVectorizer(String uid) {
        this.uid = uid;
        this.height = new IntParam((Identifiable)this, "height", "image height", ParamValidators$.MODULE$.gtEq(0.0));
        this.width = new IntParam((Identifiable)this, "width", "image width", ParamValidators$.MODULE$.gtEq(0.0));
        this.channels = new IntParam((Identifiable)this, "channels", "number of channels", ParamValidators$.MODULE$.gtEq(0.0));
        this.setDefault((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.height().$minus$greater((Object)BoxesRunTime.boxToInteger((int)28))}));
        this.setDefault((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.width().$minus$greater((Object)BoxesRunTime.boxToInteger((int)28))}));
        this.setDefault((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.channels().$minus$greater((Object)BoxesRunTime.boxToInteger((int)3))}));
    }

    public ImageVectorizer() {
        this(Identifiable$.MODULE$.randomUID("imageVectorizer"));
    }
}

