/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.text.functions;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.Accumulator;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.broadcast.Broadcast;
import org.nd4j.common.primitives.Counter;
import org.nd4j.common.primitives.Pair;

public class UpdateWordFreqAccumulatorFunction
implements Function<List<String>, Pair<List<String>, AtomicLong>> {
    private Broadcast<List<String>> stopWords;
    private Accumulator<Counter<String>> wordFreqAcc;

    public UpdateWordFreqAccumulatorFunction(Broadcast<List<String>> stopWords, Accumulator<Counter<String>> wordFreqAcc) {
        this.wordFreqAcc = wordFreqAcc;
        this.stopWords = stopWords;
    }

    public Pair<List<String>, AtomicLong> call(List<String> lstOfWords) throws Exception {
        List stops = (List)this.stopWords.getValue();
        Counter counter = new Counter();
        for (String w : lstOfWords) {
            if (w.isEmpty()) continue;
            if (!stops.isEmpty()) {
                if (stops.contains(w)) {
                    counter.incrementCount((Object)"STOP", 1.0);
                    continue;
                }
                counter.incrementCount((Object)w, 1.0);
                continue;
            }
            counter.incrementCount((Object)w, 1.0);
        }
        this.wordFreqAcc.add((Object)counter);
        AtomicLong lstOfWordsSize = new AtomicLong(lstOfWords.size());
        return new Pair(lstOfWords, (Object)lstOfWordsSize);
    }
}

