/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.rl4j.learning;

import java.io.IOException;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.CanvasFrame;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameRecorder;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.datavec.image.loader.NativeImageLoader;
import org.deeplearning4j.rl4j.learning.IHistoryProcessor;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.compression.BasicNDArrayCompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryProcessor
implements IHistoryProcessor {
    private static final Logger log = LoggerFactory.getLogger(HistoryProcessor.class);
    private final IHistoryProcessor.Configuration conf;
    private final OpenCVFrameConverter openCVFrameConverter = new OpenCVFrameConverter.ToMat();
    private CircularFifoQueue<INDArray> history;
    private FFmpegFrameRecorder fmpegFrameRecorder = null;
    public static BasicNDArrayCompressor compressor = BasicNDArrayCompressor.getInstance().setDefaultCompression("UINT8");

    public HistoryProcessor(IHistoryProcessor.Configuration conf) {
        this.conf = conf;
        this.history = new CircularFifoQueue(conf.getHistoryLength());
    }

    @Override
    public void add(INDArray obs) {
        INDArray processed = this.transform(obs);
        this.history.add((Object)processed);
    }

    @Override
    public void startMonitor(String filename, int[] shape) {
        this.stopMonitor();
        this.fmpegFrameRecorder = new FFmpegFrameRecorder(filename, shape[1], shape[0]);
        this.fmpegFrameRecorder.setVideoCodec(27);
        this.fmpegFrameRecorder.setFrameRate(30.0);
        this.fmpegFrameRecorder.setVideoQuality(30.0);
        try {
            log.info("Started monitoring: " + filename);
            this.fmpegFrameRecorder.start();
        }
        catch (FrameRecorder.Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stopMonitor() {
        if (this.fmpegFrameRecorder != null) {
            try {
                this.fmpegFrameRecorder.stop();
                this.fmpegFrameRecorder.release();
                log.info("Stopped monitoring");
            }
            catch (FrameRecorder.Exception e) {
                e.printStackTrace();
            }
        }
        this.fmpegFrameRecorder = null;
    }

    @Override
    public boolean isMonitoring() {
        return this.fmpegFrameRecorder != null;
    }

    @Override
    public void record(INDArray raw) {
        if (this.fmpegFrameRecorder != null) {
            long[] shape = raw.shape();
            opencv_core.Mat ocvmat = new opencv_core.Mat((int)shape[0], (int)shape[1], opencv_core.CV_32FC((int)3), raw.data().pointer());
            opencv_core.Mat cvmat = new opencv_core.Mat(new float[]{shape[0], shape[1], opencv_core.CV_8UC((int)3)});
            ocvmat.convertTo(cvmat, opencv_core.CV_8UC((int)3), 255.0, 0.0);
            Frame frame = this.openCVFrameConverter.convert(cvmat);
            try {
                this.fmpegFrameRecorder.record(frame);
            }
            catch (FrameRecorder.Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public INDArray[] getHistory() {
        INDArray[] array = new INDArray[this.getConf().getHistoryLength()];
        for (int i = 0; i < this.conf.getHistoryLength(); ++i) {
            array[i] = (INDArray)this.history.get(i);
        }
        return array;
    }

    private INDArray transform(INDArray raw) {
        long[] shape = raw.shape();
        opencv_core.Mat ocvmat = new opencv_core.Mat((int)shape[0], (int)shape[1], opencv_core.CV_32FC((int)3), raw.data().pointer());
        opencv_core.Mat cvmat = new opencv_core.Mat(new float[]{shape[0], shape[1], opencv_core.CV_8UC((int)3)});
        ocvmat.convertTo(cvmat, opencv_core.CV_8UC((int)3), 255.0, 0.0);
        opencv_imgproc.cvtColor((opencv_core.Mat)cvmat, (opencv_core.Mat)cvmat, (int)7);
        opencv_core.Mat resized = new opencv_core.Mat(this.conf.getRescaledHeight(), this.conf.getRescaledWidth(), opencv_core.CV_8UC((int)1));
        opencv_imgproc.resize((opencv_core.Mat)cvmat, (opencv_core.Mat)resized, (opencv_core.Size)new opencv_core.Size(this.conf.getRescaledWidth(), this.conf.getRescaledHeight()));
        opencv_core.Mat cropped = resized.apply(new opencv_core.Rect(this.conf.getOffsetX(), this.conf.getOffsetY(), this.conf.getCroppingWidth(), this.conf.getCroppingHeight()));
        INDArray out = null;
        try {
            out = new NativeImageLoader((long)this.conf.getCroppingHeight(), (long)this.conf.getCroppingWidth()).asMatrix(cropped);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        out = out.reshape(new long[]{1L, this.conf.getCroppingHeight(), this.conf.getCroppingWidth()});
        INDArray compressed = compressor.compress(out);
        return compressed;
    }

    @Override
    public double getScale() {
        return 255.0;
    }

    public void waitKP() {
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void show(opencv_core.Mat m) {
        OpenCVFrameConverter.ToMat converter = new OpenCVFrameConverter.ToMat();
        CanvasFrame canvas = new CanvasFrame("LOL", 1.0);
        canvas.showImage(converter.convert(m));
    }

    @Override
    public IHistoryProcessor.Configuration getConf() {
        return this.conf;
    }
}

