/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.rl4j.learning;

import org.nd4j.linalg.api.ndarray.INDArray;

public interface IHistoryProcessor {
    public Configuration getConf();

    public INDArray[] getHistory();

    public void record(INDArray var1);

    public void add(INDArray var1);

    public void startMonitor(String var1, int[] var2);

    public void stopMonitor();

    public boolean isMonitoring();

    public double getScale();

    public static final class Configuration {
        private final int historyLength;
        private final int rescaledWidth;
        private final int rescaledHeight;
        private final int croppingWidth;
        private final int croppingHeight;
        private final int offsetX;
        private final int offsetY;
        private final int skipFrame;

        public Configuration() {
            this.historyLength = 4;
            this.rescaledWidth = 84;
            this.rescaledHeight = 84;
            this.croppingWidth = 84;
            this.croppingHeight = 84;
            this.offsetX = 0;
            this.offsetY = 0;
            this.skipFrame = 4;
        }

        public int[] getShape() {
            return new int[]{this.getHistoryLength(), this.getCroppingHeight(), this.getCroppingWidth()};
        }

        public static ConfigurationBuilder builder() {
            return new ConfigurationBuilder();
        }

        public int getHistoryLength() {
            return this.historyLength;
        }

        public int getRescaledWidth() {
            return this.rescaledWidth;
        }

        public int getRescaledHeight() {
            return this.rescaledHeight;
        }

        public int getCroppingWidth() {
            return this.croppingWidth;
        }

        public int getCroppingHeight() {
            return this.croppingHeight;
        }

        public int getOffsetX() {
            return this.offsetX;
        }

        public int getOffsetY() {
            return this.offsetY;
        }

        public int getSkipFrame() {
            return this.skipFrame;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Configuration)) {
                return false;
            }
            Configuration other = (Configuration)o;
            if (this.getHistoryLength() != other.getHistoryLength()) {
                return false;
            }
            if (this.getRescaledWidth() != other.getRescaledWidth()) {
                return false;
            }
            if (this.getRescaledHeight() != other.getRescaledHeight()) {
                return false;
            }
            if (this.getCroppingWidth() != other.getCroppingWidth()) {
                return false;
            }
            if (this.getCroppingHeight() != other.getCroppingHeight()) {
                return false;
            }
            if (this.getOffsetX() != other.getOffsetX()) {
                return false;
            }
            if (this.getOffsetY() != other.getOffsetY()) {
                return false;
            }
            return this.getSkipFrame() == other.getSkipFrame();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getHistoryLength();
            result = result * 59 + this.getRescaledWidth();
            result = result * 59 + this.getRescaledHeight();
            result = result * 59 + this.getCroppingWidth();
            result = result * 59 + this.getCroppingHeight();
            result = result * 59 + this.getOffsetX();
            result = result * 59 + this.getOffsetY();
            result = result * 59 + this.getSkipFrame();
            return result;
        }

        public String toString() {
            return "IHistoryProcessor.Configuration(historyLength=" + this.getHistoryLength() + ", rescaledWidth=" + this.getRescaledWidth() + ", rescaledHeight=" + this.getRescaledHeight() + ", croppingWidth=" + this.getCroppingWidth() + ", croppingHeight=" + this.getCroppingHeight() + ", offsetX=" + this.getOffsetX() + ", offsetY=" + this.getOffsetY() + ", skipFrame=" + this.getSkipFrame() + ")";
        }

        public Configuration(int historyLength, int rescaledWidth, int rescaledHeight, int croppingWidth, int croppingHeight, int offsetX, int offsetY, int skipFrame) {
            this.historyLength = historyLength;
            this.rescaledWidth = rescaledWidth;
            this.rescaledHeight = rescaledHeight;
            this.croppingWidth = croppingWidth;
            this.croppingHeight = croppingHeight;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.skipFrame = skipFrame;
        }

        public static class ConfigurationBuilder {
            private int historyLength;
            private int rescaledWidth;
            private int rescaledHeight;
            private int croppingWidth;
            private int croppingHeight;
            private int offsetX;
            private int offsetY;
            private int skipFrame;

            ConfigurationBuilder() {
            }

            public ConfigurationBuilder historyLength(int historyLength) {
                this.historyLength = historyLength;
                return this;
            }

            public ConfigurationBuilder rescaledWidth(int rescaledWidth) {
                this.rescaledWidth = rescaledWidth;
                return this;
            }

            public ConfigurationBuilder rescaledHeight(int rescaledHeight) {
                this.rescaledHeight = rescaledHeight;
                return this;
            }

            public ConfigurationBuilder croppingWidth(int croppingWidth) {
                this.croppingWidth = croppingWidth;
                return this;
            }

            public ConfigurationBuilder croppingHeight(int croppingHeight) {
                this.croppingHeight = croppingHeight;
                return this;
            }

            public ConfigurationBuilder offsetX(int offsetX) {
                this.offsetX = offsetX;
                return this;
            }

            public ConfigurationBuilder offsetY(int offsetY) {
                this.offsetY = offsetY;
                return this;
            }

            public ConfigurationBuilder skipFrame(int skipFrame) {
                this.skipFrame = skipFrame;
                return this;
            }

            public Configuration build() {
                return new Configuration(this.historyLength, this.rescaledWidth, this.rescaledHeight, this.croppingWidth, this.croppingHeight, this.offsetX, this.offsetY, this.skipFrame);
            }

            public String toString() {
                return "IHistoryProcessor.Configuration.ConfigurationBuilder(historyLength=" + this.historyLength + ", rescaledWidth=" + this.rescaledWidth + ", rescaledHeight=" + this.rescaledHeight + ", croppingWidth=" + this.croppingWidth + ", croppingHeight=" + this.croppingHeight + ", offsetX=" + this.offsetX + ", offsetY=" + this.offsetY + ", skipFrame=" + this.skipFrame + ")";
            }
        }
    }
}

