/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.rl4j.learning.async;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.rl4j.learning.async.AsyncConfiguration;
import org.deeplearning4j.rl4j.network.NeuralNet;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncGlobal<NN extends NeuralNet>
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(AsyncGlobal.class);
    private final NN current;
    private final ConcurrentLinkedQueue<Pair<Gradient[], Integer>> queue;
    private final AsyncConfiguration a3cc;
    private AtomicInteger T = new AtomicInteger(0);
    private NN target;
    private boolean running = true;

    public AsyncGlobal(NN initial, AsyncConfiguration a3cc) {
        this.current = initial;
        this.target = initial.clone();
        this.a3cc = a3cc;
        this.queue = new ConcurrentLinkedQueue();
    }

    public boolean isTrainingComplete() {
        return this.T.get() >= this.a3cc.getMaxStep();
    }

    public void enqueue(Gradient[] gradient, Integer nstep) {
        this.queue.add((Pair<Gradient[], Integer>)new Pair((Object)gradient, (Object)nstep));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isTrainingComplete() && this.running) {
            if (this.queue.isEmpty()) continue;
            Pair<Gradient[], Integer> pair = this.queue.poll();
            this.T.addAndGet((Integer)pair.getSecond());
            Gradient[] gradient = (Gradient[])pair.getFirst();
            AsyncGlobal asyncGlobal = this;
            synchronized (asyncGlobal) {
                this.current.applyGradient(gradient, (Integer)pair.getSecond());
            }
            if (this.a3cc.getTargetDqnUpdateFreq() == -1 || this.T.get() / this.a3cc.getTargetDqnUpdateFreq() <= (this.T.get() - (Integer)pair.getSecond()) / this.a3cc.getTargetDqnUpdateFreq()) continue;
            log.info("TARGET UPDATE at T = " + this.T.get());
            asyncGlobal = this;
            synchronized (asyncGlobal) {
                this.target.copy(this.current);
            }
        }
    }

    public NN getCurrent() {
        return this.current;
    }

    public AtomicInteger getT() {
        return this.T;
    }

    public NN getTarget() {
        return this.target;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }
}

