/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.rl4j.learning.async;

import org.deeplearning4j.rl4j.learning.Learning;
import org.deeplearning4j.rl4j.learning.async.AsyncConfiguration;
import org.deeplearning4j.rl4j.learning.async.AsyncGlobal;
import org.deeplearning4j.rl4j.learning.async.AsyncThread;
import org.deeplearning4j.rl4j.network.NeuralNet;
import org.deeplearning4j.rl4j.space.ActionSpace;
import org.deeplearning4j.rl4j.space.Encodable;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncLearning<O extends Encodable, A, AS extends ActionSpace<A>, NN extends NeuralNet>
extends Learning<O, A, AS, NN> {
    private static final Logger log = LoggerFactory.getLogger(AsyncLearning.class);

    public AsyncLearning(AsyncConfiguration conf) {
        super(conf);
    }

    @Override
    public abstract AsyncConfiguration getConfiguration();

    protected abstract AsyncThread newThread(int var1);

    protected abstract AsyncGlobal<NN> getAsyncGlobal();

    protected void startGlobalThread() {
        this.getAsyncGlobal().start();
    }

    protected boolean isTrainingComplete() {
        return this.getAsyncGlobal().isTrainingComplete();
    }

    public void launchThreads() {
        this.startGlobalThread();
        for (int i = 0; i < this.getConfiguration().getNumThread(); ++i) {
            AsyncThread t = this.newThread(i);
            Nd4j.getAffinityManager().attachThreadToDevice((Thread)t, Integer.valueOf(i % Nd4j.getAffinityManager().getNumberOfDevices()));
            t.start();
        }
        log.info("Threads launched.");
    }

    @Override
    public int getStepCounter() {
        return this.getAsyncGlobal().getT().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void train() {
        try {
            log.info("AsyncLearning training starting.");
            this.launchThreads();
            this.getDataManager().writeInfo(this);
            AsyncLearning asyncLearning = this;
            synchronized (asyncLearning) {
                while (!this.isTrainingComplete() && this.getAsyncGlobal().isRunning()) {
                    this.getPolicy().play(this.getMdp(), this.getHistoryProcessor());
                    this.getDataManager().writeInfo(this);
                    this.wait(20000L);
                }
            }
        }
        catch (Exception e) {
            log.error("Training failed.", (Throwable)e);
            e.printStackTrace();
        }
    }
}

