/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.rl4j.learning.async;

import java.util.Arrays;
import org.nd4j.linalg.api.ndarray.INDArray;

public final class MiniTrans<A> {
    private final INDArray obs;
    private final A action;
    private final INDArray[] output;
    private final double reward;

    public INDArray getObs() {
        return this.obs;
    }

    public A getAction() {
        return this.action;
    }

    public INDArray[] getOutput() {
        return this.output;
    }

    public double getReward() {
        return this.reward;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MiniTrans)) {
            return false;
        }
        MiniTrans other = (MiniTrans)o;
        INDArray this$obs = this.getObs();
        INDArray other$obs = other.getObs();
        if (this$obs == null ? other$obs != null : !this$obs.equals(other$obs)) {
            return false;
        }
        A this$action = this.getAction();
        A other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOutput(), other.getOutput())) {
            return false;
        }
        return Double.compare(this.getReward(), other.getReward()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        INDArray $obs = this.getObs();
        result = result * 59 + ($obs == null ? 43 : $obs.hashCode());
        A $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getOutput());
        long $reward = Double.doubleToLongBits(this.getReward());
        result = result * 59 + (int)($reward >>> 32 ^ $reward);
        return result;
    }

    public String toString() {
        return "MiniTrans(obs=" + this.getObs() + ", action=" + this.getAction() + ", output=" + Arrays.deepToString(this.getOutput()) + ", reward=" + this.getReward() + ")";
    }

    public MiniTrans(INDArray obs, A action, INDArray[] output, double reward) {
        this.obs = obs;
        this.action = action;
        this.output = output;
        this.reward = reward;
    }
}

