/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.rl4j.learning.async.a3c.discrete;

import org.deeplearning4j.rl4j.learning.async.AsyncConfiguration;
import org.deeplearning4j.rl4j.learning.async.AsyncGlobal;
import org.deeplearning4j.rl4j.learning.async.AsyncLearning;
import org.deeplearning4j.rl4j.learning.async.AsyncThread;
import org.deeplearning4j.rl4j.learning.async.a3c.discrete.A3CThreadDiscrete;
import org.deeplearning4j.rl4j.mdp.MDP;
import org.deeplearning4j.rl4j.network.ac.IActorCritic;
import org.deeplearning4j.rl4j.policy.ACPolicy;
import org.deeplearning4j.rl4j.space.DiscreteSpace;
import org.deeplearning4j.rl4j.space.Encodable;
import org.deeplearning4j.rl4j.util.DataManager;

public abstract class A3CDiscrete<O extends Encodable>
extends AsyncLearning<O, Integer, DiscreteSpace, IActorCritic> {
    public final A3CConfiguration configuration;
    protected final MDP<O, Integer, DiscreteSpace> mdp;
    private final IActorCritic iActorCritic;
    private final AsyncGlobal asyncGlobal;
    private final ACPolicy<O> policy;
    private final DataManager dataManager;

    public A3CDiscrete(MDP<O, Integer, DiscreteSpace> mdp, IActorCritic iActorCritic, A3CConfiguration conf, DataManager dataManager) {
        super(conf);
        this.iActorCritic = iActorCritic;
        this.mdp = mdp;
        this.configuration = conf;
        this.dataManager = dataManager;
        this.policy = new ACPolicy(iActorCritic, this.getRandom());
        this.asyncGlobal = new AsyncGlobal<IActorCritic>(iActorCritic, conf);
        ((DiscreteSpace)mdp.getActionSpace()).setSeed(conf.getSeed());
    }

    @Override
    protected AsyncThread newThread(int i) {
        return new A3CThreadDiscrete(this.mdp.newInstance(), this.asyncGlobal, this.getConfiguration(), i, this.dataManager);
    }

    @Override
    public IActorCritic getNeuralNet() {
        return this.iActorCritic;
    }

    @Override
    public A3CConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public MDP<O, Integer, DiscreteSpace> getMdp() {
        return this.mdp;
    }

    @Override
    public AsyncGlobal getAsyncGlobal() {
        return this.asyncGlobal;
    }

    public ACPolicy<O> getPolicy() {
        return this.policy;
    }

    @Override
    public DataManager getDataManager() {
        return this.dataManager;
    }

    public static class A3CConfiguration
    implements AsyncConfiguration {
        int seed;
        int maxEpochStep;
        int maxStep;
        int numThread;
        int nstep;
        int updateStart;
        double rewardFactor;
        double gamma;
        double errorClamp;

        @Override
        public int getTargetDqnUpdateFreq() {
            return -1;
        }

        public static A3CConfigurationBuilder builder() {
            return new A3CConfigurationBuilder();
        }

        @Override
        public int getSeed() {
            return this.seed;
        }

        @Override
        public int getMaxEpochStep() {
            return this.maxEpochStep;
        }

        @Override
        public int getMaxStep() {
            return this.maxStep;
        }

        @Override
        public int getNumThread() {
            return this.numThread;
        }

        @Override
        public int getNstep() {
            return this.nstep;
        }

        @Override
        public int getUpdateStart() {
            return this.updateStart;
        }

        @Override
        public double getRewardFactor() {
            return this.rewardFactor;
        }

        @Override
        public double getGamma() {
            return this.gamma;
        }

        @Override
        public double getErrorClamp() {
            return this.errorClamp;
        }

        public void setSeed(int seed) {
            this.seed = seed;
        }

        public void setMaxEpochStep(int maxEpochStep) {
            this.maxEpochStep = maxEpochStep;
        }

        public void setMaxStep(int maxStep) {
            this.maxStep = maxStep;
        }

        public void setNumThread(int numThread) {
            this.numThread = numThread;
        }

        public void setNstep(int nstep) {
            this.nstep = nstep;
        }

        public void setUpdateStart(int updateStart) {
            this.updateStart = updateStart;
        }

        public void setRewardFactor(double rewardFactor) {
            this.rewardFactor = rewardFactor;
        }

        public void setGamma(double gamma) {
            this.gamma = gamma;
        }

        public void setErrorClamp(double errorClamp) {
            this.errorClamp = errorClamp;
        }

        public String toString() {
            return "A3CDiscrete.A3CConfiguration(seed=" + this.getSeed() + ", maxEpochStep=" + this.getMaxEpochStep() + ", maxStep=" + this.getMaxStep() + ", numThread=" + this.getNumThread() + ", nstep=" + this.getNstep() + ", updateStart=" + this.getUpdateStart() + ", rewardFactor=" + this.getRewardFactor() + ", gamma=" + this.getGamma() + ", errorClamp=" + this.getErrorClamp() + ")";
        }

        public A3CConfiguration(int seed, int maxEpochStep, int maxStep, int numThread, int nstep, int updateStart, double rewardFactor, double gamma, double errorClamp) {
            this.seed = seed;
            this.maxEpochStep = maxEpochStep;
            this.maxStep = maxStep;
            this.numThread = numThread;
            this.nstep = nstep;
            this.updateStart = updateStart;
            this.rewardFactor = rewardFactor;
            this.gamma = gamma;
            this.errorClamp = errorClamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof A3CConfiguration)) {
                return false;
            }
            A3CConfiguration other = (A3CConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSeed() != other.getSeed()) {
                return false;
            }
            if (this.getMaxEpochStep() != other.getMaxEpochStep()) {
                return false;
            }
            if (this.getMaxStep() != other.getMaxStep()) {
                return false;
            }
            if (this.getNumThread() != other.getNumThread()) {
                return false;
            }
            if (this.getNstep() != other.getNstep()) {
                return false;
            }
            if (this.getUpdateStart() != other.getUpdateStart()) {
                return false;
            }
            if (Double.compare(this.getRewardFactor(), other.getRewardFactor()) != 0) {
                return false;
            }
            if (Double.compare(this.getGamma(), other.getGamma()) != 0) {
                return false;
            }
            return Double.compare(this.getErrorClamp(), other.getErrorClamp()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof A3CConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSeed();
            result = result * 59 + this.getMaxEpochStep();
            result = result * 59 + this.getMaxStep();
            result = result * 59 + this.getNumThread();
            result = result * 59 + this.getNstep();
            result = result * 59 + this.getUpdateStart();
            long $rewardFactor = Double.doubleToLongBits(this.getRewardFactor());
            result = result * 59 + (int)($rewardFactor >>> 32 ^ $rewardFactor);
            long $gamma = Double.doubleToLongBits(this.getGamma());
            result = result * 59 + (int)($gamma >>> 32 ^ $gamma);
            long $errorClamp = Double.doubleToLongBits(this.getErrorClamp());
            result = result * 59 + (int)($errorClamp >>> 32 ^ $errorClamp);
            return result;
        }

        public static class A3CConfigurationBuilder {
            private int seed;
            private int maxEpochStep;
            private int maxStep;
            private int numThread;
            private int nstep;
            private int updateStart;
            private double rewardFactor;
            private double gamma;
            private double errorClamp;

            A3CConfigurationBuilder() {
            }

            public A3CConfigurationBuilder seed(int seed) {
                this.seed = seed;
                return this;
            }

            public A3CConfigurationBuilder maxEpochStep(int maxEpochStep) {
                this.maxEpochStep = maxEpochStep;
                return this;
            }

            public A3CConfigurationBuilder maxStep(int maxStep) {
                this.maxStep = maxStep;
                return this;
            }

            public A3CConfigurationBuilder numThread(int numThread) {
                this.numThread = numThread;
                return this;
            }

            public A3CConfigurationBuilder nstep(int nstep) {
                this.nstep = nstep;
                return this;
            }

            public A3CConfigurationBuilder updateStart(int updateStart) {
                this.updateStart = updateStart;
                return this;
            }

            public A3CConfigurationBuilder rewardFactor(double rewardFactor) {
                this.rewardFactor = rewardFactor;
                return this;
            }

            public A3CConfigurationBuilder gamma(double gamma) {
                this.gamma = gamma;
                return this;
            }

            public A3CConfigurationBuilder errorClamp(double errorClamp) {
                this.errorClamp = errorClamp;
                return this;
            }

            public A3CConfiguration build() {
                return new A3CConfiguration(this.seed, this.maxEpochStep, this.maxStep, this.numThread, this.nstep, this.updateStart, this.rewardFactor, this.gamma, this.errorClamp);
            }

            public String toString() {
                return "A3CDiscrete.A3CConfiguration.A3CConfigurationBuilder(seed=" + this.seed + ", maxEpochStep=" + this.maxEpochStep + ", maxStep=" + this.maxStep + ", numThread=" + this.numThread + ", nstep=" + this.nstep + ", updateStart=" + this.updateStart + ", rewardFactor=" + this.rewardFactor + ", gamma=" + this.gamma + ", errorClamp=" + this.errorClamp + ")";
            }
        }
    }
}

