/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.rl4j.learning.async.nstep.discrete;

import org.deeplearning4j.rl4j.learning.async.AsyncConfiguration;
import org.deeplearning4j.rl4j.learning.async.AsyncGlobal;
import org.deeplearning4j.rl4j.learning.async.AsyncLearning;
import org.deeplearning4j.rl4j.learning.async.AsyncThread;
import org.deeplearning4j.rl4j.learning.async.nstep.discrete.AsyncNStepQLearningThreadDiscrete;
import org.deeplearning4j.rl4j.mdp.MDP;
import org.deeplearning4j.rl4j.network.dqn.IDQN;
import org.deeplearning4j.rl4j.policy.DQNPolicy;
import org.deeplearning4j.rl4j.policy.Policy;
import org.deeplearning4j.rl4j.space.DiscreteSpace;
import org.deeplearning4j.rl4j.space.Encodable;
import org.deeplearning4j.rl4j.util.DataManager;

public abstract class AsyncNStepQLearningDiscrete<O extends Encodable>
extends AsyncLearning<O, Integer, DiscreteSpace, IDQN> {
    public final AsyncNStepQLConfiguration configuration;
    private final MDP<O, Integer, DiscreteSpace> mdp;
    private final DataManager dataManager;
    private final AsyncGlobal<IDQN> asyncGlobal;

    public AsyncNStepQLearningDiscrete(MDP<O, Integer, DiscreteSpace> mdp, IDQN dqn, AsyncNStepQLConfiguration conf, DataManager dataManager) {
        super(conf);
        this.mdp = mdp;
        this.dataManager = dataManager;
        this.configuration = conf;
        this.asyncGlobal = new AsyncGlobal<IDQN>(dqn, conf);
        ((DiscreteSpace)mdp.getActionSpace()).setSeed(conf.getSeed());
    }

    @Override
    public AsyncThread newThread(int i) {
        return new AsyncNStepQLearningThreadDiscrete(this.mdp.newInstance(), this.asyncGlobal, this.configuration, i, this.dataManager);
    }

    @Override
    public IDQN getNeuralNet() {
        return this.asyncGlobal.getCurrent();
    }

    @Override
    public Policy<O, Integer> getPolicy() {
        return new DQNPolicy(this.getNeuralNet());
    }

    @Override
    public AsyncNStepQLConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public MDP<O, Integer, DiscreteSpace> getMdp() {
        return this.mdp;
    }

    @Override
    public DataManager getDataManager() {
        return this.dataManager;
    }

    @Override
    public AsyncGlobal<IDQN> getAsyncGlobal() {
        return this.asyncGlobal;
    }

    public static class AsyncNStepQLConfiguration
    implements AsyncConfiguration {
        int seed;
        int maxEpochStep;
        int maxStep;
        int numThread;
        int nstep;
        int targetDqnUpdateFreq;
        int updateStart;
        double rewardFactor;
        double gamma;
        double errorClamp;
        float minEpsilon;
        int epsilonNbStep;

        public static AsyncNStepQLConfigurationBuilder builder() {
            return new AsyncNStepQLConfigurationBuilder();
        }

        @Override
        public int getSeed() {
            return this.seed;
        }

        @Override
        public int getMaxEpochStep() {
            return this.maxEpochStep;
        }

        @Override
        public int getMaxStep() {
            return this.maxStep;
        }

        @Override
        public int getNumThread() {
            return this.numThread;
        }

        @Override
        public int getNstep() {
            return this.nstep;
        }

        @Override
        public int getTargetDqnUpdateFreq() {
            return this.targetDqnUpdateFreq;
        }

        @Override
        public int getUpdateStart() {
            return this.updateStart;
        }

        @Override
        public double getRewardFactor() {
            return this.rewardFactor;
        }

        @Override
        public double getGamma() {
            return this.gamma;
        }

        @Override
        public double getErrorClamp() {
            return this.errorClamp;
        }

        public float getMinEpsilon() {
            return this.minEpsilon;
        }

        public int getEpsilonNbStep() {
            return this.epsilonNbStep;
        }

        public void setSeed(int seed) {
            this.seed = seed;
        }

        public void setMaxEpochStep(int maxEpochStep) {
            this.maxEpochStep = maxEpochStep;
        }

        public void setMaxStep(int maxStep) {
            this.maxStep = maxStep;
        }

        public void setNumThread(int numThread) {
            this.numThread = numThread;
        }

        public void setNstep(int nstep) {
            this.nstep = nstep;
        }

        public void setTargetDqnUpdateFreq(int targetDqnUpdateFreq) {
            this.targetDqnUpdateFreq = targetDqnUpdateFreq;
        }

        public void setUpdateStart(int updateStart) {
            this.updateStart = updateStart;
        }

        public void setRewardFactor(double rewardFactor) {
            this.rewardFactor = rewardFactor;
        }

        public void setGamma(double gamma) {
            this.gamma = gamma;
        }

        public void setErrorClamp(double errorClamp) {
            this.errorClamp = errorClamp;
        }

        public void setMinEpsilon(float minEpsilon) {
            this.minEpsilon = minEpsilon;
        }

        public void setEpsilonNbStep(int epsilonNbStep) {
            this.epsilonNbStep = epsilonNbStep;
        }

        public String toString() {
            return "AsyncNStepQLearningDiscrete.AsyncNStepQLConfiguration(seed=" + this.getSeed() + ", maxEpochStep=" + this.getMaxEpochStep() + ", maxStep=" + this.getMaxStep() + ", numThread=" + this.getNumThread() + ", nstep=" + this.getNstep() + ", targetDqnUpdateFreq=" + this.getTargetDqnUpdateFreq() + ", updateStart=" + this.getUpdateStart() + ", rewardFactor=" + this.getRewardFactor() + ", gamma=" + this.getGamma() + ", errorClamp=" + this.getErrorClamp() + ", minEpsilon=" + this.getMinEpsilon() + ", epsilonNbStep=" + this.getEpsilonNbStep() + ")";
        }

        public AsyncNStepQLConfiguration(int seed, int maxEpochStep, int maxStep, int numThread, int nstep, int targetDqnUpdateFreq, int updateStart, double rewardFactor, double gamma, double errorClamp, float minEpsilon, int epsilonNbStep) {
            this.seed = seed;
            this.maxEpochStep = maxEpochStep;
            this.maxStep = maxStep;
            this.numThread = numThread;
            this.nstep = nstep;
            this.targetDqnUpdateFreq = targetDqnUpdateFreq;
            this.updateStart = updateStart;
            this.rewardFactor = rewardFactor;
            this.gamma = gamma;
            this.errorClamp = errorClamp;
            this.minEpsilon = minEpsilon;
            this.epsilonNbStep = epsilonNbStep;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsyncNStepQLConfiguration)) {
                return false;
            }
            AsyncNStepQLConfiguration other = (AsyncNStepQLConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSeed() != other.getSeed()) {
                return false;
            }
            if (this.getMaxEpochStep() != other.getMaxEpochStep()) {
                return false;
            }
            if (this.getMaxStep() != other.getMaxStep()) {
                return false;
            }
            if (this.getNumThread() != other.getNumThread()) {
                return false;
            }
            if (this.getNstep() != other.getNstep()) {
                return false;
            }
            if (this.getTargetDqnUpdateFreq() != other.getTargetDqnUpdateFreq()) {
                return false;
            }
            if (this.getUpdateStart() != other.getUpdateStart()) {
                return false;
            }
            if (Double.compare(this.getRewardFactor(), other.getRewardFactor()) != 0) {
                return false;
            }
            if (Double.compare(this.getGamma(), other.getGamma()) != 0) {
                return false;
            }
            if (Double.compare(this.getErrorClamp(), other.getErrorClamp()) != 0) {
                return false;
            }
            if (Float.compare(this.getMinEpsilon(), other.getMinEpsilon()) != 0) {
                return false;
            }
            return this.getEpsilonNbStep() == other.getEpsilonNbStep();
        }

        protected boolean canEqual(Object other) {
            return other instanceof AsyncNStepQLConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSeed();
            result = result * 59 + this.getMaxEpochStep();
            result = result * 59 + this.getMaxStep();
            result = result * 59 + this.getNumThread();
            result = result * 59 + this.getNstep();
            result = result * 59 + this.getTargetDqnUpdateFreq();
            result = result * 59 + this.getUpdateStart();
            long $rewardFactor = Double.doubleToLongBits(this.getRewardFactor());
            result = result * 59 + (int)($rewardFactor >>> 32 ^ $rewardFactor);
            long $gamma = Double.doubleToLongBits(this.getGamma());
            result = result * 59 + (int)($gamma >>> 32 ^ $gamma);
            long $errorClamp = Double.doubleToLongBits(this.getErrorClamp());
            result = result * 59 + (int)($errorClamp >>> 32 ^ $errorClamp);
            result = result * 59 + Float.floatToIntBits(this.getMinEpsilon());
            result = result * 59 + this.getEpsilonNbStep();
            return result;
        }

        public static class AsyncNStepQLConfigurationBuilder {
            private int seed;
            private int maxEpochStep;
            private int maxStep;
            private int numThread;
            private int nstep;
            private int targetDqnUpdateFreq;
            private int updateStart;
            private double rewardFactor;
            private double gamma;
            private double errorClamp;
            private float minEpsilon;
            private int epsilonNbStep;

            AsyncNStepQLConfigurationBuilder() {
            }

            public AsyncNStepQLConfigurationBuilder seed(int seed) {
                this.seed = seed;
                return this;
            }

            public AsyncNStepQLConfigurationBuilder maxEpochStep(int maxEpochStep) {
                this.maxEpochStep = maxEpochStep;
                return this;
            }

            public AsyncNStepQLConfigurationBuilder maxStep(int maxStep) {
                this.maxStep = maxStep;
                return this;
            }

            public AsyncNStepQLConfigurationBuilder numThread(int numThread) {
                this.numThread = numThread;
                return this;
            }

            public AsyncNStepQLConfigurationBuilder nstep(int nstep) {
                this.nstep = nstep;
                return this;
            }

            public AsyncNStepQLConfigurationBuilder targetDqnUpdateFreq(int targetDqnUpdateFreq) {
                this.targetDqnUpdateFreq = targetDqnUpdateFreq;
                return this;
            }

            public AsyncNStepQLConfigurationBuilder updateStart(int updateStart) {
                this.updateStart = updateStart;
                return this;
            }

            public AsyncNStepQLConfigurationBuilder rewardFactor(double rewardFactor) {
                this.rewardFactor = rewardFactor;
                return this;
            }

            public AsyncNStepQLConfigurationBuilder gamma(double gamma) {
                this.gamma = gamma;
                return this;
            }

            public AsyncNStepQLConfigurationBuilder errorClamp(double errorClamp) {
                this.errorClamp = errorClamp;
                return this;
            }

            public AsyncNStepQLConfigurationBuilder minEpsilon(float minEpsilon) {
                this.minEpsilon = minEpsilon;
                return this;
            }

            public AsyncNStepQLConfigurationBuilder epsilonNbStep(int epsilonNbStep) {
                this.epsilonNbStep = epsilonNbStep;
                return this;
            }

            public AsyncNStepQLConfiguration build() {
                return new AsyncNStepQLConfiguration(this.seed, this.maxEpochStep, this.maxStep, this.numThread, this.nstep, this.targetDqnUpdateFreq, this.updateStart, this.rewardFactor, this.gamma, this.errorClamp, this.minEpsilon, this.epsilonNbStep);
            }

            public String toString() {
                return "AsyncNStepQLearningDiscrete.AsyncNStepQLConfiguration.AsyncNStepQLConfigurationBuilder(seed=" + this.seed + ", maxEpochStep=" + this.maxEpochStep + ", maxStep=" + this.maxStep + ", numThread=" + this.numThread + ", nstep=" + this.nstep + ", targetDqnUpdateFreq=" + this.targetDqnUpdateFreq + ", updateStart=" + this.updateStart + ", rewardFactor=" + this.rewardFactor + ", gamma=" + this.gamma + ", errorClamp=" + this.errorClamp + ", minEpsilon=" + this.minEpsilon + ", epsilonNbStep=" + this.epsilonNbStep + ")";
            }
        }
    }
}

