/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.rl4j.learning.sync;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.deeplearning4j.rl4j.learning.sync.IExpReplay;
import org.deeplearning4j.rl4j.learning.sync.Transition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpReplay<A>
implements IExpReplay<A> {
    private static final Logger log = LoggerFactory.getLogger(ExpReplay.class);
    private final int batchSize;
    private final Random random;
    private CircularFifoQueue<Transition<A>> storage;

    public ExpReplay(int maxSize, int batchSize, int seed) {
        this.batchSize = batchSize;
        this.random = new Random(seed);
        this.storage = new CircularFifoQueue(maxSize);
    }

    public ArrayList<Transition<A>> getBatch(int size) {
        ArrayList<Transition<A>> batch = new ArrayList<Transition<A>>(size);
        int storageSize = this.storage.size();
        int actualBatchSize = Math.min(storageSize, size);
        int[] actualIndex = ThreadLocalRandom.current().ints(0, storageSize).distinct().limit(actualBatchSize).toArray();
        for (int i = 0; i < actualBatchSize; ++i) {
            Transition trans = (Transition)this.storage.get(actualIndex[i]);
            batch.add(trans.dup());
        }
        return batch;
    }

    @Override
    public ArrayList<Transition<A>> getBatch() {
        return this.getBatch(this.batchSize);
    }

    @Override
    public void store(Transition<A> transition) {
        this.storage.add(transition);
    }
}

