/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.rl4j.learning.sync;

import org.deeplearning4j.rl4j.learning.ILearning;
import org.deeplearning4j.rl4j.learning.Learning;
import org.deeplearning4j.rl4j.network.NeuralNet;
import org.deeplearning4j.rl4j.space.ActionSpace;
import org.deeplearning4j.rl4j.space.Encodable;
import org.deeplearning4j.rl4j.util.DataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SyncLearning<O extends Encodable, A, AS extends ActionSpace<A>, NN extends NeuralNet>
extends Learning<O, A, AS, NN> {
    private static final Logger log = LoggerFactory.getLogger(SyncLearning.class);
    private int lastSave = -100000;

    public SyncLearning(ILearning.LConfiguration conf) {
        super(conf);
    }

    @Override
    public void train() {
        try {
            log.info("training starting.");
            this.getDataManager().writeInfo(this);
            while (this.getStepCounter() < this.getConfiguration().getMaxStep()) {
                this.preEpoch();
                DataManager.StatEntry statEntry = this.trainEpoch();
                this.postEpoch();
                this.incrementEpoch();
                if (this.getStepCounter() - this.lastSave >= 100000) {
                    this.getDataManager().save(this);
                    this.lastSave = this.getStepCounter();
                }
                this.getDataManager().appendStat(statEntry);
                this.getDataManager().writeInfo(this);
                log.info("Epoch: " + this.getEpochCounter() + ", reward: " + statEntry.getReward());
            }
        }
        catch (Exception e) {
            log.error("Training failed.", (Throwable)e);
            e.printStackTrace();
        }
    }

    protected abstract void preEpoch();

    protected abstract void postEpoch();

    protected abstract DataManager.StatEntry trainEpoch();
}

