/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.rl4j.learning.sync;

import java.util.Arrays;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public final class Transition<A> {
    private final INDArray[] observation;
    private final A action;
    private final double reward;
    private final boolean isTerminal;
    private final INDArray nextObservation;

    public static INDArray concat(INDArray[] history) {
        INDArray arr = Nd4j.concat((int)0, (INDArray[])history);
        return arr;
    }

    public Transition<A> dup() {
        INDArray[] dupObservation = Transition.dup(this.observation);
        INDArray nextObs = this.nextObservation.dup();
        return new Transition<A>(dupObservation, this.action, this.reward, this.isTerminal, nextObs);
    }

    public static INDArray[] dup(INDArray[] history) {
        INDArray[] dupHistory = new INDArray[history.length];
        for (int i = 0; i < history.length; ++i) {
            dupHistory[i] = history[i].dup();
        }
        return dupHistory;
    }

    public static INDArray[] append(INDArray[] history, INDArray append) {
        INDArray[] appended = new INDArray[history.length];
        appended[0] = append;
        for (int i = 0; i < history.length - 1; ++i) {
            appended[i + 1] = history[i];
        }
        return appended;
    }

    public Transition(INDArray[] observation, A action, double reward, boolean isTerminal, INDArray nextObservation) {
        this.observation = observation;
        this.action = action;
        this.reward = reward;
        this.isTerminal = isTerminal;
        this.nextObservation = nextObservation;
    }

    public INDArray[] getObservation() {
        return this.observation;
    }

    public A getAction() {
        return this.action;
    }

    public double getReward() {
        return this.reward;
    }

    public boolean isTerminal() {
        return this.isTerminal;
    }

    public INDArray getNextObservation() {
        return this.nextObservation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transition)) {
            return false;
        }
        Transition other = (Transition)o;
        if (!Arrays.deepEquals(this.getObservation(), other.getObservation())) {
            return false;
        }
        A this$action = this.getAction();
        A other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        if (Double.compare(this.getReward(), other.getReward()) != 0) {
            return false;
        }
        if (this.isTerminal() != other.isTerminal()) {
            return false;
        }
        INDArray this$nextObservation = this.getNextObservation();
        INDArray other$nextObservation = other.getNextObservation();
        return !(this$nextObservation == null ? other$nextObservation != null : !this$nextObservation.equals(other$nextObservation));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getObservation());
        A $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        long $reward = Double.doubleToLongBits(this.getReward());
        result = result * 59 + (int)($reward >>> 32 ^ $reward);
        result = result * 59 + (this.isTerminal() ? 79 : 97);
        INDArray $nextObservation = this.getNextObservation();
        result = result * 59 + ($nextObservation == null ? 43 : $nextObservation.hashCode());
        return result;
    }

    public String toString() {
        return "Transition(observation=" + Arrays.deepToString(this.getObservation()) + ", action=" + this.getAction() + ", reward=" + this.getReward() + ", isTerminal=" + this.isTerminal() + ", nextObservation=" + this.getNextObservation() + ")";
    }
}

