/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.rl4j.mdp.toy;

import org.deeplearning4j.gym.StepReply;
import org.deeplearning4j.rl4j.learning.NeuralNetFetchable;
import org.deeplearning4j.rl4j.mdp.MDP;
import org.deeplearning4j.rl4j.mdp.toy.SimpleToyState;
import org.deeplearning4j.rl4j.network.dqn.IDQN;
import org.deeplearning4j.rl4j.space.ArrayObservationSpace;
import org.deeplearning4j.rl4j.space.DiscreteSpace;
import org.deeplearning4j.rl4j.space.ObservationSpace;
import org.json.JSONObject;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleToy
implements MDP<SimpleToyState, Integer, DiscreteSpace> {
    private static final Logger log = LoggerFactory.getLogger(SimpleToy.class);
    private final int maxStep;
    private DiscreteSpace actionSpace = new DiscreteSpace(2);
    private ObservationSpace<SimpleToyState> observationSpace = new ArrayObservationSpace(new int[]{1});
    private SimpleToyState simpleToyState;
    private NeuralNetFetchable<IDQN> fetchable;

    public SimpleToy(int maxStep) {
        this.maxStep = maxStep;
    }

    public void printTest(int maxStep) {
        INDArray input = Nd4j.create((int)maxStep, (int)1);
        for (int i = 0; i < maxStep; ++i) {
            input.putRow((long)i, Nd4j.create((double[])new SimpleToyState(i, i).toArray()));
        }
        INDArray output = this.fetchable.getNeuralNet().output(input);
        log.info(output.toString());
    }

    public void close() {
    }

    public boolean isDone() {
        return this.simpleToyState.getStep() == this.maxStep;
    }

    public SimpleToyState reset() {
        if (this.fetchable != null) {
            this.printTest(this.maxStep);
        }
        this.simpleToyState = new SimpleToyState(0, 0);
        return this.simpleToyState;
    }

    public StepReply<SimpleToyState> step(Integer a) {
        double reward = this.simpleToyState.getStep() % 2 == 0 ? (double)(1 - a) : (double)a.intValue();
        this.simpleToyState = new SimpleToyState(this.simpleToyState.getI() + 1, this.simpleToyState.getStep() + 1);
        return new StepReply((Object)this.simpleToyState, reward, this.isDone(), new JSONObject("{}"));
    }

    public SimpleToy newInstance() {
        SimpleToy simpleToy = new SimpleToy(this.maxStep);
        simpleToy.setFetchable(this.fetchable);
        return simpleToy;
    }

    public DiscreteSpace getActionSpace() {
        return this.actionSpace;
    }

    public ObservationSpace<SimpleToyState> getObservationSpace() {
        return this.observationSpace;
    }

    public void setFetchable(NeuralNetFetchable<IDQN> fetchable) {
        this.fetchable = fetchable;
    }
}

