/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.rl4j.network.ac;

import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.LossUtil;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.shade.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ActorCriticLoss
implements ILossFunction {
    public static final double BETA = 0.01;

    private INDArray scoreArray(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        INDArray output = activationFn.getActivation(preOutput.dup(), true).addi((Number)1.0E-5);
        INDArray logOutput = Transforms.log((INDArray)output, (boolean)true);
        INDArray entropy = output.muli(logOutput);
        INDArray scoreArr = logOutput.muli(labels).subi(entropy.muli((Number)0.01));
        if (mask != null) {
            LossUtil.applyMask((INDArray)scoreArr, (INDArray)mask);
        }
        return scoreArr;
    }

    public double computeScore(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask, boolean average) {
        INDArray scoreArr = this.scoreArray(labels, preOutput, activationFn, mask);
        double score = -scoreArr.sumNumber().doubleValue();
        return average ? score / (double)scoreArr.size(0) : score;
    }

    public INDArray computeScoreArray(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        INDArray scoreArr = this.scoreArray(labels, preOutput, activationFn, mask);
        return scoreArr.sum(new int[]{1}).muli((Number)-1);
    }

    public INDArray computeGradient(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        INDArray output = activationFn.getActivation(preOutput.dup(), true).addi((Number)1.0E-5);
        INDArray logOutput = Transforms.log((INDArray)output, (boolean)true);
        INDArray entropyDev = logOutput.addi((Number)1);
        INDArray dLda = output.rdivi(labels).subi(entropyDev.muli((Number)0.01)).negi();
        INDArray grad = (INDArray)activationFn.backprop(preOutput, dLda).getFirst();
        if (mask != null) {
            LossUtil.applyMask((INDArray)grad, (INDArray)mask);
        }
        return grad;
    }

    public Pair<Double, INDArray> computeGradientAndScore(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask, boolean average) {
        return new Pair((Object)this.computeScore(labels, preOutput, activationFn, mask, average), (Object)this.computeGradient(labels, preOutput, activationFn, mask));
    }

    public String toString() {
        return "ActorCriticLoss()";
    }

    public String name() {
        return this.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActorCriticLoss)) {
            return false;
        }
        ActorCriticLoss other = (ActorCriticLoss)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActorCriticLoss;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }
}

