/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.rl4j.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.deeplearning4j.rl4j.learning.ILearning;
import org.deeplearning4j.rl4j.learning.Learning;
import org.deeplearning4j.rl4j.network.dqn.DQN;
import org.deeplearning4j.rl4j.network.dqn.IDQN;
import org.deeplearning4j.util.ModelSerializer;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataManager {
    private static final Logger log = LoggerFactory.getLogger(DataManager.class);
    private final String home = System.getProperty("user.home");
    private final ObjectMapper mapper = new ObjectMapper();
    private String dataRoot = this.home + "/" + "rl4j-data";
    private boolean saveData;
    private String currentDir;

    public DataManager() throws IOException {
        this.create(this.dataRoot, false);
    }

    public DataManager(boolean saveData) throws IOException {
        this.create(this.dataRoot, saveData);
    }

    public DataManager(String dataRoot, boolean saveData) throws IOException {
        this.create(dataRoot, saveData);
    }

    private static void writeEntry(InputStream inputStream, ZipOutputStream zipStream) throws IOException {
        int bytesRead;
        byte[] bytes = new byte[1024];
        while ((bytesRead = inputStream.read(bytes)) != -1) {
            zipStream.write(bytes, 0, bytesRead);
        }
    }

    public static void save(String path, Learning learning) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(path));){
            DataManager.save(os, learning);
        }
    }

    public static void save(OutputStream os, Learning learning) throws IOException {
        try (ZipOutputStream zipfile = new ZipOutputStream(os);){
            ZipEntry config = new ZipEntry("configuration.json");
            zipfile.putNextEntry(config);
            String json = new ObjectMapper().writeValueAsString((Object)learning.getConfiguration());
            DataManager.writeEntry(new ByteArrayInputStream(json.getBytes()), zipfile);
            ZipEntry dqn = new ZipEntry("dqn.bin");
            zipfile.putNextEntry(dqn);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            learning.getNeuralNet().save(bos);
            bos.flush();
            bos.close();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bos.toByteArray());
            DataManager.writeEntry(inputStream, zipfile);
            if (learning.getHistoryProcessor() != null) {
                ZipEntry hpconf = new ZipEntry("hpconf.bin");
                zipfile.putNextEntry(hpconf);
                ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
                learning.getNeuralNet().save(bos2);
                bos2.flush();
                bos2.close();
                ByteArrayInputStream inputStream2 = new ByteArrayInputStream(bos2.toByteArray());
                DataManager.writeEntry(inputStream2, zipfile);
            }
            zipfile.flush();
            zipfile.close();
        }
    }

    public static <C> Pair<IDQN, C> load(File file, Class<C> cClass) throws IOException {
        log.info("Deserializing: " + file.getName());
        Object conf = null;
        DQN dqn = null;
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry config = zipFile.getEntry("configuration.json");
            InputStream stream = zipFile.getInputStream(config);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String line = "";
            StringBuilder js = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                js.append(line).append("\n");
            }
            String json = js.toString();
            reader.close();
            stream.close();
            conf = new ObjectMapper().readValue(json, cClass);
            ZipEntry dqnzip = zipFile.getEntry("dqn.bin");
            InputStream dqnstream = zipFile.getInputStream(dqnzip);
            File tmpFile = File.createTempFile("restore", "dqn");
            Files.copy(dqnstream, Paths.get(tmpFile.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            dqn = new DQN(ModelSerializer.restoreMultiLayerNetwork((File)tmpFile));
            dqnstream.close();
        }
        return new Pair(dqn, conf);
    }

    public static <C> Pair<IDQN, C> load(String path, Class<C> cClass) throws IOException {
        return DataManager.load(new File(path), cClass);
    }

    public static <C> Pair<IDQN, C> load(InputStream is, Class<C> cClass) throws IOException {
        File tmpFile = File.createTempFile("restore", "learning");
        Files.copy(is, Paths.get(tmpFile.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        return DataManager.load(tmpFile, cClass);
    }

    private void create(String dataRoot, boolean saveData) throws IOException {
        this.saveData = saveData;
        this.dataRoot = dataRoot;
        this.createSubdir();
    }

    public String createSubdir() throws IOException {
        if (!this.saveData) {
            return "";
        }
        File dr = new File(this.dataRoot);
        dr.mkdirs();
        File[] rootChildren = dr.listFiles();
        int i = 1;
        while (this.childrenExist(rootChildren, i + "")) {
            ++i;
        }
        File f = new File(this.dataRoot + "/" + i);
        f.mkdirs();
        this.currentDir = f.getAbsolutePath();
        log.info("Created training data directory: " + this.currentDir);
        File mov = new File(this.getVideoDir());
        mov.mkdirs();
        File model = new File(this.getModelDir());
        model.mkdirs();
        File stat = new File(this.getStat());
        File info = new File(this.getInfo());
        stat.createNewFile();
        info.createNewFile();
        return f.getAbsolutePath();
    }

    public String getVideoDir() {
        return this.currentDir + "/" + "video";
    }

    public String getModelDir() {
        return this.currentDir + "/" + "model";
    }

    public String getInfo() {
        return this.currentDir + "/" + "info";
    }

    public String getStat() {
        return this.currentDir + "/" + "stat";
    }

    public void appendStat(StatEntry statEntry) throws IOException {
        if (!this.saveData) {
            return;
        }
        Path statPath = Paths.get(this.getStat(), new String[0]);
        String toAppend = this.toJson(statEntry);
        Files.write(statPath, toAppend.getBytes(), StandardOpenOption.APPEND);
    }

    private String toJson(Object object) throws IOException {
        return this.mapper.writeValueAsString(object) + "\n";
    }

    public void writeInfo(ILearning iLearning) throws IOException {
        if (!this.saveData) {
            return;
        }
        Path infoPath = Paths.get(this.getInfo(), new String[0]);
        Info info = new Info(iLearning.getClass().getSimpleName(), iLearning.getMdp().getClass().getSimpleName(), iLearning.getConfiguration(), iLearning.getStepCounter(), System.currentTimeMillis());
        String toWrite = this.toJson(info);
        Files.write(infoPath, toWrite.getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
    }

    private boolean childrenExist(File[] files, String children) {
        boolean exists = false;
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getName().equals(children)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public void save(Learning learning) throws IOException {
        if (!this.saveData) {
            return;
        }
        DataManager.save(this.getModelDir() + "/" + learning.getStepCounter() + ".training", learning);
        learning.getNeuralNet().save(this.getModelDir() + "/" + learning.getStepCounter() + ".model");
    }

    public boolean isSaveData() {
        return this.saveData;
    }

    public static final class Info {
        private final String trainingName;
        private final String mdpName;
        private final ILearning.LConfiguration conf;
        private final int stepCounter;
        private final long millisTime;

        public static InfoBuilder builder() {
            return new InfoBuilder();
        }

        public String getTrainingName() {
            return this.trainingName;
        }

        public String getMdpName() {
            return this.mdpName;
        }

        public ILearning.LConfiguration getConf() {
            return this.conf;
        }

        public int getStepCounter() {
            return this.stepCounter;
        }

        public long getMillisTime() {
            return this.millisTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Info)) {
                return false;
            }
            Info other = (Info)o;
            String this$trainingName = this.getTrainingName();
            String other$trainingName = other.getTrainingName();
            if (this$trainingName == null ? other$trainingName != null : !this$trainingName.equals(other$trainingName)) {
                return false;
            }
            String this$mdpName = this.getMdpName();
            String other$mdpName = other.getMdpName();
            if (this$mdpName == null ? other$mdpName != null : !this$mdpName.equals(other$mdpName)) {
                return false;
            }
            ILearning.LConfiguration this$conf = this.getConf();
            ILearning.LConfiguration other$conf = other.getConf();
            if (this$conf == null ? other$conf != null : !this$conf.equals(other$conf)) {
                return false;
            }
            if (this.getStepCounter() != other.getStepCounter()) {
                return false;
            }
            return this.getMillisTime() == other.getMillisTime();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $trainingName = this.getTrainingName();
            result = result * 59 + ($trainingName == null ? 43 : $trainingName.hashCode());
            String $mdpName = this.getMdpName();
            result = result * 59 + ($mdpName == null ? 43 : $mdpName.hashCode());
            ILearning.LConfiguration $conf = this.getConf();
            result = result * 59 + ($conf == null ? 43 : $conf.hashCode());
            result = result * 59 + this.getStepCounter();
            long $millisTime = this.getMillisTime();
            result = result * 59 + (int)($millisTime >>> 32 ^ $millisTime);
            return result;
        }

        public String toString() {
            return "DataManager.Info(trainingName=" + this.getTrainingName() + ", mdpName=" + this.getMdpName() + ", conf=" + this.getConf() + ", stepCounter=" + this.getStepCounter() + ", millisTime=" + this.getMillisTime() + ")";
        }

        public Info(String trainingName, String mdpName, ILearning.LConfiguration conf, int stepCounter, long millisTime) {
            this.trainingName = trainingName;
            this.mdpName = mdpName;
            this.conf = conf;
            this.stepCounter = stepCounter;
            this.millisTime = millisTime;
        }

        public static class InfoBuilder {
            private String trainingName;
            private String mdpName;
            private ILearning.LConfiguration conf;
            private int stepCounter;
            private long millisTime;

            InfoBuilder() {
            }

            public InfoBuilder trainingName(String trainingName) {
                this.trainingName = trainingName;
                return this;
            }

            public InfoBuilder mdpName(String mdpName) {
                this.mdpName = mdpName;
                return this;
            }

            public InfoBuilder conf(ILearning.LConfiguration conf) {
                this.conf = conf;
                return this;
            }

            public InfoBuilder stepCounter(int stepCounter) {
                this.stepCounter = stepCounter;
                return this;
            }

            public InfoBuilder millisTime(long millisTime) {
                this.millisTime = millisTime;
                return this;
            }

            public Info build() {
                return new Info(this.trainingName, this.mdpName, this.conf, this.stepCounter, this.millisTime);
            }

            public String toString() {
                return "DataManager.Info.InfoBuilder(trainingName=" + this.trainingName + ", mdpName=" + this.mdpName + ", conf=" + this.conf + ", stepCounter=" + this.stepCounter + ", millisTime=" + this.millisTime + ")";
            }
        }
    }

    public static interface StatEntry {
        public int getEpochCounter();

        public int getStepCounter();

        public double getReward();
    }
}

