/*
 * Decompiled with CFR 0.152.
 */
package org.deflaker.surefire;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.Set;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.surefire.booter.Command;
import org.apache.maven.surefire.booter.CommandListener;
import org.apache.maven.surefire.booter.CommandReader;
import org.apache.maven.surefire.common.junit4.ClassMethod;
import org.apache.maven.surefire.common.junit4.JUnit4Reflector;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.common.junit4.JUnit4RunListenerFactory;
import org.apache.maven.surefire.common.junit4.JUnit4TestChecker;
import org.apache.maven.surefire.common.junit4.JUnitTestFailureListener;
import org.apache.maven.surefire.common.junit4.Notifier;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.testset.TestRequest;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.RunOrderCalculator;
import org.apache.maven.surefire.util.ScanResult;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;
import org.deflaker.runtime.Base64;
import org.deflaker.surefire.FixedJUnit4ProviderUtil;
import org.deflaker.surefire.FlakySurefireReportParser;
import org.deflaker.surefire.TestResolverFilter;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReExecJunit4Provider
extends AbstractProvider {
    private static final String UNDETERMINED_TESTS_DESCRIPTION = "cannot determine test in forked JVM with surefire";
    private final ClassLoader testClassLoader;
    private final Collection<org.junit.runner.notification.RunListener> customRunListeners;
    private final JUnit4TestChecker jUnit4TestChecker;
    private TestListResolver testResolver;
    private final ProviderParameters providerParameters;
    private final RunOrderCalculator runOrderCalculator;
    private final ScanResult scanResult;
    private final int rerunFailingTestsCount;
    private final String builddir;
    private final int rerunSeparateJVMCount;
    private final CommandReader commandsReader;
    private TestsToRun testsToRun;

    public ReExecJunit4Provider(ProviderParameters bootParams) {
        this.commandsReader = bootParams.isInsideFork() ? CommandReader.getReader().setShutdown(bootParams.getShutdown()) : null;
        this.providerParameters = bootParams;
        this.testClassLoader = bootParams.getTestClassLoader();
        this.scanResult = bootParams.getScanResult();
        this.runOrderCalculator = bootParams.getRunOrderCalculator();
        String listeners = (String)bootParams.getProviderProperties().get("listener");
        this.customRunListeners = Collections.unmodifiableCollection(JUnit4RunListenerFactory.createCustomListeners(listeners));
        this.jUnit4TestChecker = new JUnit4TestChecker(this.testClassLoader);
        TestRequest testRequest = bootParams.getTestRequest();
        this.testResolver = testRequest.getTestListResolver();
        this.rerunFailingTestsCount = testRequest.getRerunFailingTestsCount();
        this.builddir = (String)bootParams.getProviderProperties().get("builddir");
        this.rerunSeparateJVMCount = bootParams.getProviderProperties().get("rerunCount") != null ? Integer.valueOf((String)bootParams.getProviderProperties().get("rerunCount")) : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult invoke(Object forkTestSet) throws TestSetFailedException {
        RunResult runResult;
        File f;
        if (this.rerunSeparateJVMCount > 0 && (f = new File(this.builddir + "/diffcov-tests-rerun")).exists()) {
            Scanner s = null;
            try {
                String t;
                s = new Scanner(f);
                ArrayList<String> tests = new ArrayList<String>();
                HashSet<String> passedTests = ReExecJunit4Provider.getPassedRerunMethods(this.builddir);
                while (s.hasNextLine()) {
                    t = s.nextLine();
                    if (passedTests.contains(t)) continue;
                    tests.add(t);
                }
                this.testResolver = new TestListResolver(tests);
                if (tests.isEmpty()) {
                    t = RunResult.noTestsRun();
                    return t;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                s.close();
            }
        }
        this.upgradeCheck();
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        try {
            RunListener reporter = reporterFactory.createReporter();
            ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)((ConsoleOutputReceiver)reporter));
            if (this.testsToRun == null) {
                this.setTestsToRun(forkTestSet);
            }
            Notifier notifier = new Notifier(new JUnit4RunListener(reporter), this.getSkipAfterFailureCount());
            Result result = new Result();
            notifier.addListeners(this.customRunListeners).addListener(result.createListener());
            if (this.isFailFast() && this.commandsReader != null) {
                this.registerPleaseStopJUnitListener(notifier);
            }
            try {
                notifier.fireTestRunStarted(this.testsToRun.allowEagerReading() ? ReExecJunit4Provider.createTestsDescription(this.testsToRun) : JUnit4Reflector.createDescription(UNDETERMINED_TESTS_DESCRIPTION));
                if (this.commandsReader != null) {
                    this.registerShutdownListener(this.testsToRun);
                    this.commandsReader.awaitStarted();
                }
                for (Class testToRun : this.testsToRun) {
                    this.executeTestSet(testToRun, reporter, notifier);
                }
            }
            finally {
                notifier.fireTestRunFinished(result);
                notifier.removeListeners();
            }
            JUnit4RunListener.rethrowAnyTestMechanismFailures(result);
        }
        finally {
            runResult = reporterFactory.close();
        }
        return runResult;
    }

    private void setTestsToRun(Object forkTestSet) throws TestSetFailedException {
        this.testsToRun = forkTestSet instanceof TestsToRun ? (TestsToRun)forkTestSet : (forkTestSet instanceof Class ? TestsToRun.fromClass((Class)((Class)forkTestSet)) : this.scanClassPath());
    }

    private boolean isRerunFailingTests() {
        return this.rerunFailingTestsCount > 0;
    }

    private boolean isFailFast() {
        return this.providerParameters.getSkipAfterFailureCount() > 0;
    }

    private int getSkipAfterFailureCount() {
        return this.isFailFast() ? this.providerParameters.getSkipAfterFailureCount() : 0;
    }

    private void registerShutdownListener(final TestsToRun testsToRun) {
        this.commandsReader.addShutdownListener(new CommandListener(){

            public void update(Command command) {
                testsToRun.markTestSetFinished();
            }
        });
    }

    private void registerPleaseStopJUnitListener(final Notifier notifier) {
        this.commandsReader.addSkipNextTestsListener(new CommandListener(){

            public void update(Command command) {
                notifier.pleaseStop();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTestSet(Class<?> clazz, RunListener reporter, Notifier notifier) {
        SimpleReportEntry report = new SimpleReportEntry(((Object)((Object)this)).getClass().getName(), clazz.getName());
        reporter.testSetStarting((ReportEntry)report);
        try {
            this.executeWithRerun(clazz, notifier);
        }
        catch (Throwable e) {
            if (this.isFailFast() && e instanceof StoppedByUserException) {
                String reason = e.getClass().getName();
                Description skippedTest = JUnit4Reflector.createDescription(clazz.getName(), new Annotation[]{JUnit4Reflector.createIgnored(reason)});
                notifier.fireTestIgnored(skippedTest);
            } else {
                String reportName = report.getName();
                String reportSourceName = report.getSourceName();
                PojoStackTraceWriter stackWriter = new PojoStackTraceWriter(reportSourceName, reportName, e);
                reporter.testError((ReportEntry)SimpleReportEntry.withException((String)reportSourceName, (String)reportName, (StackTraceWriter)stackWriter));
            }
        }
        finally {
            reporter.testSetCompleted((ReportEntry)report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeWithRerun(Class<?> clazz, Notifier notifier) throws TestSetFailedException {
        JUnitTestFailureListener failureListener = new JUnitTestFailureListener();
        notifier.addListener(failureListener);
        boolean hasMethodFilter = this.testResolver != null && this.testResolver.hasMethodPatterns();
        try {
            try {
                notifier.asFailFast(this.isFailFast());
                ReExecJunit4Provider.execute(clazz, notifier, hasMethodFilter ? this.createMethodFilter() : null);
            }
            finally {
                notifier.asFailFast(false);
            }
            if (this.isRerunFailingTests()) {
                Notifier rerunNotifier = Notifier.pureNotifier();
                notifier.copyListenersTo(rerunNotifier);
                for (int i = 0; i < this.rerunFailingTestsCount && !failureListener.getAllFailures().isEmpty(); ++i) {
                    notifier.fireTestRunStarted(null);
                    Set<ClassMethod> failedTests = FixedJUnit4ProviderUtil.generateFailingTests(failureListener.getAllFailures());
                    failureListener.reset();
                    if (!failedTests.isEmpty()) {
                        this.executeFailedMethod(rerunNotifier, failedTests);
                    }
                    notifier.fireTestRunFinished(null);
                }
            }
        }
        finally {
            notifier.removeListener(failureListener);
        }
    }

    public Iterable<Class<?>> getSuites() {
        if (this.rerunSeparateJVMCount > 0) {
            LinkedList theTests = new LinkedList();
            for (Class c : this.getFailedTests(this.builddir)) {
                for (int i = 0; i < this.rerunSeparateJVMCount; ++i) {
                    theTests.add(c);
                }
            }
            return theTests;
        }
        this.testsToRun = this.scanClassPath();
        return this.testsToRun;
    }

    private static HashSet<String> getPassedRerunMethods(String buildDir) {
        HashSet<String> passedTests = new HashSet<String>();
        File f = new File(buildDir + "/surefire-reports-isolated-reruns/rerunResults");
        if (f.exists()) {
            try {
                Scanner s = new Scanner(f);
                while (s.hasNextLine()) {
                    String[] d = s.nextLine().split("\t");
                    if (!"OK".equals(d[1])) continue;
                    passedTests.add(Base64.fromBase64((String)d[0]));
                }
                s.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return passedTests;
    }

    private TestsToRun getFailedTests(String buildDir) {
        HashSet failedTestClasses = new HashSet();
        FlakySurefireReportParser parser = new FlakySurefireReportParser(Collections.singletonList(new File(buildDir + "/surefire-reports")), Locale.US);
        try {
            File lst = new File(this.builddir + "/diffcov-tests-rerun");
            if (lst.exists()) {
                lst.delete();
            }
            FileWriter failedTestWriter = new FileWriter(lst);
            List<ReportTestSuite> tests = parser.parseXMLReportFiles();
            for (ReportTestSuite t : tests) {
                String cn;
                if (t.getNumberOfErrors() <= 0 && t.getNumberOfFailures() <= 0 && t.getNumberOfFlakes() <= 0 || (cn = t.getFullClassName()).startsWith("deflaker.")) continue;
                failedTestClasses.add(this.testClassLoader.loadClass(t.getFullClassName()));
                for (ReportTestCase c : t.getTestCases()) {
                    if (!c.hasFailure() && c.getFailureType() == null) continue;
                    failedTestWriter.write(cn + "#" + c.getName() + "\n");
                }
            }
            failedTestWriter.close();
        }
        catch (MavenReportException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new TestsToRun(failedTestClasses);
    }

    private TestsToRun scanClassPath() {
        TestsToRun scannedClasses = this.scanResult.applyFilter((ScannerFilter)this.jUnit4TestChecker, this.testClassLoader);
        return this.runOrderCalculator.orderTestClasses(scannedClasses);
    }

    private void upgradeCheck() throws TestSetFailedException {
        List classesSkippedByValidation;
        if (ReExecJunit4Provider.isJUnit4UpgradeCheck() && !(classesSkippedByValidation = this.scanResult.getClassesSkippedByValidation((ScannerFilter)this.jUnit4TestChecker, this.testClassLoader)).isEmpty()) {
            StringBuilder reason = new StringBuilder();
            reason.append("Updated check failed\n");
            reason.append("There are tests that would be run with junit4 / surefire 2.6 but not with [2.7,):\n");
            for (Class testClass : classesSkippedByValidation) {
                reason.append("   ");
                reason.append(testClass.getName());
                reason.append("\n");
            }
            throw new TestSetFailedException(reason.toString());
        }
    }

    static Description createTestsDescription(Iterable<Class<?>> classes) {
        Description description = JUnit4Reflector.createDescription("null");
        for (Class<?> clazz : classes) {
            description.addChild(JUnit4Reflector.createDescription(clazz.getName()));
        }
        return description;
    }

    private static boolean isJUnit4UpgradeCheck() {
        return System.getProperty("surefire.junit4.upgradecheck") != null;
    }

    private static void execute(Class<?> testClass, Notifier notifier, Filter filter) {
        int classModifiers = testClass.getModifiers();
        if (!Modifier.isAbstract(classModifiers) && !Modifier.isInterface(classModifiers)) {
            Runner runner;
            Request request = Request.aClass(testClass);
            if (filter != null) {
                request = request.filterWith(filter);
            }
            if (ReExecJunit4Provider.countTestsInRunner((runner = request.getRunner()).getDescription()) != 0) {
                runner.run((RunNotifier)notifier);
            }
        }
    }

    private void executeFailedMethod(Notifier notifier, Set<ClassMethod> failedMethods) throws TestSetFailedException {
        for (ClassMethod failedMethod : failedMethods) {
            try {
                Class<?> methodClass = Class.forName(failedMethod.getClazz(), true, this.testClassLoader);
                String methodName = failedMethod.getMethod();
                System.setProperty("deflaker.inProcessRerun", "true");
                Request.method(methodClass, (String)methodName).getRunner().run((RunNotifier)notifier);
            }
            catch (ClassNotFoundException e) {
                throw new TestSetFailedException("Unable to create test class '" + failedMethod.getClazz() + "'", (Throwable)e);
            }
            finally {
                System.clearProperty("deflaker.inProcessRerun");
            }
        }
    }

    private static int countTestsInRunner(Description description) {
        if (description.isSuite()) {
            int count = 0;
            for (Description child : description.getChildren()) {
                if (ReExecJunit4Provider.hasFilteredOutAllChildren(child)) continue;
                count += ReExecJunit4Provider.countTestsInRunner(child);
            }
            return count;
        }
        if (description.isTest()) {
            return ReExecJunit4Provider.hasFilteredOutAllChildren(description) ? 0 : 1;
        }
        return 0;
    }

    private static boolean hasFilteredOutAllChildren(Description description) {
        String name = description.getDisplayName();
        if (name == null) {
            return true;
        }
        return (name = name.trim()).startsWith("initializationError0(org.junit.runner.manipulation.Filter)") || name.startsWith("initializationError(org.junit.runner.manipulation.Filter)");
    }

    private Filter createMethodFilter() {
        TestListResolver methodFilter = TestListResolver.optionallyWildcardFilter((TestListResolver)this.testResolver);
        return methodFilter.isEmpty() || methodFilter.isWildcard() ? null : new TestResolverFilter(methodFilter);
    }
}

