/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;

public class HibernateDDLFormatterTask
extends Task {
    private File inputFile;
    private File outputFile;
    private String delimiter = ";";

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void execute() {
        if (this.inputFile == null) {
            throw new BuildException("`inputFile' attribute is required");
        }
        if (this.outputFile == null) {
            throw new BuildException("`outputFile' attribute is required");
        }
        if (this.outputFile.getParent() != null && !this.outputFile.getParentFile().exists() && !this.outputFile.getParentFile().mkdirs()) {
            throw new BuildException("error creating directory `" + this.outputFile.getParentFile() + "'");
        }
        Formatter formatter = FormatStyle.DDL.getFormatter();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.inputFile), Charset.defaultCharset()));
             PrintWriter writer = new PrintWriter(new FileWriter(this.outputFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] sqls;
                line = line.trim();
                for (String sql : sqls = (formatter.format(line) + this.delimiter).split("\n")) {
                    sql = sql.replaceAll("\\s+$", "").replaceAll("\\t", "    ");
                    writer.println(sql);
                }
            }
        }
        catch (IOException e) {
            throw new BuildException("error reading file`" + this.inputFile + "'", (Throwable)e);
        }
    }
}

