/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.dellroad.stuff.io.BufferOverflowException;
import org.dellroad.stuff.java.CheckedExceptionWrapper;
import org.dellroad.stuff.java.Predicate;
import org.dellroad.stuff.java.TimedWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncOutputStream
extends FilterOutputStream {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final int MIN_BUFFER_SIZE = 20;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFDF;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String threadName;
    private byte[] buf;
    private int count;
    private int flushMark = -1;
    private Thread thread;
    private IOException exception;
    private boolean closed;
    private boolean expand;

    public AsyncOutputStream(OutputStream out) {
        this(out, 0, AsyncOutputStream.class.getSimpleName() + "-" + COUNTER.incrementAndGet());
    }

    public AsyncOutputStream(OutputStream out, String name) {
        this(out, 0, name);
    }

    public AsyncOutputStream(OutputStream out, int bufsize, String name) {
        super(out);
        if (out == null) {
            throw new IllegalArgumentException("null output");
        }
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (bufsize < 0) {
            throw new IllegalArgumentException("invalid bufsize " + bufsize);
        }
        this.threadName = name;
        this.expand = bufsize == 0;
        this.buf = new byte[Math.min(Math.max(bufsize, 20), 0x7FFFFFDF)];
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public synchronized void write(byte[] data, int off, int len) throws IOException {
        this.checkExceptions();
        if (len < 0) {
            throw new IllegalArgumentException("len = " + len);
        }
        if (len == 0) {
            return;
        }
        if (this.count + len > this.buf.length) {
            if (!this.expand) {
                throw new BufferOverflowException(this.count + " + " + len + " = " + (this.count + len) + " byte(s) would exceed the " + this.buf.length + " byte buffer");
            }
            this.resizeBuffer(Math.max(this.count + len, this.buf.length * 2));
            byte[] newBuf = new byte[Math.max(this.count + len, this.buf.length * 2)];
            System.arraycopy(this.buf, 0, newBuf, 0, this.count);
            this.buf = newBuf;
        }
        System.arraycopy(data, off, this.buf, this.count, len);
        this.count += len;
        this.startThreadIfNecessary();
        this.notifyAll();
    }

    @Override
    public synchronized void flush() throws IOException {
        this.checkExceptions();
        this.flushMark = this.count;
        this.startThreadIfNecessary();
        this.notifyAll();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.startThreadIfNecessary();
        this.notifyAll();
    }

    public synchronized IOException getException() {
        return this.exception;
    }

    public synchronized int getBufferSize() {
        return this.buf.length;
    }

    public synchronized int availableBufferSpace() throws IOException {
        this.checkExceptions();
        return this.buf.length - this.count;
    }

    public synchronized boolean isWorkOutstanding() throws IOException {
        this.checkExceptions();
        return this.threadHasWork();
    }

    public synchronized boolean waitForSpace(final int numBytes, long timeout) throws IOException, InterruptedException {
        if (this.expand) {
            return true;
        }
        if (numBytes > this.buf.length) {
            throw new IllegalArgumentException("numBytes (" + numBytes + ") > buffer size (" + this.buf.length + ")");
        }
        return this.waitForPredicate(timeout, new Predicate(){

            @Override
            public boolean test() {
                return AsyncOutputStream.this.buf.length - AsyncOutputStream.this.count >= numBytes;
            }
        });
    }

    public synchronized boolean waitForIdle(long timeout) throws IOException, InterruptedException {
        return this.waitForPredicate(timeout, new Predicate(){

            @Override
            public boolean test() {
                return !AsyncOutputStream.this.threadHasWork();
            }
        });
    }

    private void checkExceptions() throws IOException {
        if (this.closed) {
            throw new IOException("instance has been closed");
        }
        if (this.exception != null) {
            throw new IOException("exception from underlying output stream", this.exception);
        }
    }

    private boolean threadHasWork() {
        return this.count > 0 || this.flushMark != -1 || this.closed;
    }

    private void startThreadIfNecessary() {
        assert (Thread.holdsLock(this));
        if (this.thread == null && this.threadHasWork()) {
            this.thread = new Thread(this.threadName){

                @Override
                public void run() {
                    AsyncOutputStream.this.threadMain();
                }
            };
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    private void resizeBuffer(int size) {
        assert (Thread.holdsLock(this));
        assert (this.count <= size);
        size = Math.min(size, 0x7FFFFFDF);
        size = Math.max(size, 20);
        byte[] newBuf = new byte[size];
        System.arraycopy(this.buf, 0, newBuf, 0, this.count);
        this.buf = newBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadMain() {
        try {
            this.runLoop();
        }
        catch (Throwable t) {
            AsyncOutputStream asyncOutputStream = this;
            synchronized (asyncOutputStream) {
                this.exception = t instanceof IOException ? (IOException)t : new IOException("caught unexpected exception", t);
                this.notifyAll();
            }
        }
        finally {
            AsyncOutputStream asyncOutputStream = this;
            synchronized (asyncOutputStream) {
                this.thread = null;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLoop() throws IOException, InterruptedException {
        while (true) {
            boolean close;
            boolean flush;
            int wlen;
            byte[] currbuf;
            AsyncOutputStream asyncOutputStream = this;
            synchronized (asyncOutputStream) {
                while (!this.threadHasWork()) {
                    this.wait();
                }
            }
            AsyncOutputStream asyncOutputStream2 = this;
            synchronized (asyncOutputStream2) {
                currbuf = this.buf;
                wlen = this.count;
                flush = this.flushMark == 0;
                close = this.closed;
            }
            if (wlen > 0) {
                this.out.write(currbuf, 0, wlen);
                asyncOutputStream2 = this;
                synchronized (asyncOutputStream2) {
                    System.arraycopy(this.buf, wlen, this.buf, 0, this.count - wlen);
                    this.count -= wlen;
                    if (this.flushMark != -1) {
                        this.flushMark = Math.max(0, this.flushMark - wlen);
                    }
                    if (this.count <= this.buf.length >> 7) {
                        this.resizeBuffer(this.count);
                    }
                    this.notifyAll();
                }
            }
            if (flush) {
                this.out.flush();
                asyncOutputStream2 = this;
                synchronized (asyncOutputStream2) {
                    if (this.flushMark == 0) {
                        this.flushMark = -1;
                        this.notifyAll();
                    }
                }
            }
            if (close) break;
        }
        this.out.close();
    }

    private synchronized boolean waitForPredicate(long timeout, final Predicate predicate) throws IOException, InterruptedException {
        try {
            return TimedWait.wait(this, timeout, new Predicate(){

                @Override
                public boolean test() {
                    try {
                        AsyncOutputStream.this.checkExceptions();
                    }
                    catch (IOException e) {
                        throw new CheckedExceptionWrapper(e);
                    }
                    return predicate.test();
                }
            });
        }
        catch (CheckedExceptionWrapper e) {
            throw (IOException)e.getException();
        }
    }
}

