/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.dellroad.stuff.string.DateEncoder;

public class CSVOutput {
    private final CSVWriter writer;
    private final String[] columns;

    public CSVOutput(Writer writer, String ... columns) {
        this(writer, Arrays.asList(columns));
    }

    public CSVOutput(Writer writer, Iterable<String> columns) {
        this(new CSVWriter((Writer)new BufferedWriter(writer)), columns);
        if (writer == null) {
            throw new IllegalArgumentException("null writer");
        }
    }

    public CSVOutput(CSVWriter writer, Iterable<String> columns) {
        if (writer == null) {
            throw new IllegalArgumentException("null writer");
        }
        if (columns == null) {
            throw new IllegalArgumentException("null columns");
        }
        this.writer = writer;
        LinkedHashSet<String> columnSet = new LinkedHashSet<String>();
        for (String column : columns) {
            if (columnSet.add(column)) continue;
            throw new IllegalArgumentException("duplicate column name `" + column + "'");
        }
        this.columns = columnSet.toArray(new String[columnSet.size()]);
        this.writer.writeNext(this.columns);
    }

    public void writeRow(Map<String, ?> row) {
        HashSet<String> unknowns = new HashSet<String>(row.keySet());
        unknowns.removeAll(Arrays.asList(this.columns));
        if (!unknowns.isEmpty()) {
            throw new IllegalArgumentException("row contains unknown column(s): " + unknowns);
        }
        String[] values = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            values[i] = this.formatObject(this.columns[i], row.get(this.columns[i]));
        }
        this.writer.writeNext(values);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    protected String formatObject(String columnName, Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "1" : "0";
        }
        if (value instanceof Date) {
            return this.formatDate(columnName, (Date)value);
        }
        return String.valueOf(value);
    }

    protected String formatDate(String columnName, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("null date");
        }
        return DateEncoder.encode(date);
    }
}

