/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.dellroad.stuff.io.AsyncInputStream;
import org.dellroad.stuff.io.IdleTimeoutException;
import org.dellroad.stuff.java.Predicate;
import org.dellroad.stuff.java.TimedWait;

public class IdleTimeoutInputStream
extends InputStream
implements AsyncInputStream.Listener {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final int OPEN = 0;
    private static final int EOF = 1;
    private static final int EXCEPTION = 2;
    private static final int CLOSED = 3;
    private final AsyncInputStream asyncInputStream;
    private final long timeout;
    private final byte[] xferBuf = new byte[500];
    private Throwable exception;
    private int xferLen;
    private int state;

    public IdleTimeoutInputStream(InputStream in, String threadName, long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout < 0");
        }
        if (threadName == null) {
            threadName = this.getClass().getSimpleName() + "-" + COUNTER.incrementAndGet();
        }
        this.asyncInputStream = new AsyncInputStream(in, threadName, this);
        this.timeout = timeout;
    }

    public IdleTimeoutInputStream(InputStream in, long timeout) {
        this(in, null, timeout);
    }

    @Override
    public synchronized int read() throws IOException {
        if (!this.waitForData(this.timeout, false)) {
            return -1;
        }
        if (this.xferLen == this.xferBuf.length) {
            this.notifyAll();
        }
        int r = this.xferBuf[0] & 0xFF;
        System.arraycopy(this.xferBuf, 1, this.xferBuf, 0, --this.xferLen);
        return r;
    }

    @Override
    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        if (off < 0) {
            throw new IndexOutOfBoundsException("off < 0");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len < 0");
        }
        if (off + len > buf.length) {
            throw new IndexOutOfBoundsException("off + len > buf.length");
        }
        if (!this.waitForData(this.timeout, false)) {
            return -1;
        }
        if (this.xferLen == this.xferBuf.length) {
            this.notifyAll();
        }
        len = Math.min(len, this.xferLen);
        System.arraycopy(this.xferBuf, 0, buf, 0, len);
        System.arraycopy(this.xferBuf, len, this.xferBuf, 0, this.xferLen -= len);
        return len;
    }

    private synchronized boolean waitForData(long duration, boolean exceptionOnEOF) throws IOException {
        boolean timedOut = false;
        while (!timedOut) {
            switch (this.state) {
                case 0: {
                    if (this.xferLen <= 0) break;
                    return true;
                }
                case 1: {
                    if (exceptionOnEOF) {
                        throw new EOFException();
                    }
                    return false;
                }
                case 2: {
                    if (this.exception instanceof IOException) {
                        throw (IOException)this.exception;
                    }
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    throw new RuntimeException(this.exception);
                }
                case 3: {
                    throw new IOException("stream is closed");
                }
                default: {
                    throw new RuntimeException("internal error");
                }
            }
            if (duration < 0L) {
                return false;
            }
            try {
                timedOut = !TimedWait.wait(this, duration, new Predicate(){

                    @Override
                    public boolean test() {
                        return IdleTimeoutInputStream.this.state != 0 || IdleTimeoutInputStream.this.xferLen > 0;
                    }
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.asyncInputStream.close();
        this.exception = new IdleTimeoutException(duration);
        this.state = 2;
        throw (IOException)this.exception;
    }

    @Override
    public synchronized void close() {
        switch (this.state) {
            case 0: 
            case 1: 
            case 2: {
                this.asyncInputStream.close();
                this.state = 3;
                this.notifyAll();
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
    }

    @Override
    public synchronized int available() throws IOException {
        return this.waitForData(-1L, false) ? this.xferLen : 0;
    }

    public synchronized void checkConnection() throws IOException {
        this.waitForData(-1L, true);
    }

    @Override
    public synchronized void handleInput(byte[] buf, int off, int len) {
        while (len > 0) {
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    return;
                }
                default: {
                    throw new RuntimeException("internal error");
                }
            }
            int copy = Math.min(len, this.xferBuf.length - this.xferLen);
            if (copy > 0) {
                System.arraycopy(buf, off, this.xferBuf, this.xferLen, copy);
                this.xferLen += copy;
                off += copy;
                len -= copy;
                if (this.xferLen != copy) continue;
                this.notifyAll();
                continue;
            }
            try {
                TimedWait.wait(this, 0L, new Predicate(){

                    @Override
                    public boolean test() {
                        return IdleTimeoutInputStream.this.state != 0 || IdleTimeoutInputStream.this.xferLen < IdleTimeoutInputStream.this.xferBuf.length;
                    }
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public synchronized void handleEOF() {
        switch (this.state) {
            case 0: {
                this.state = 1;
                this.notifyAll();
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                return;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
    }

    @Override
    public synchronized void handleException(Throwable e) {
        switch (this.state) {
            case 0: {
                this.state = 2;
                this.exception = e;
                this.notifyAll();
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                return;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
    }
}

