/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.dellroad.stuff.io.RandomEscape;

public class InputStreamReader {
    static final int CONTROL_ESCAPE = 1;
    static final int CONTROL_SEPARATOR = 2;
    private static final int RESULT_EOF = -1;
    private static final int RESULT_SEPARATOR = -2;
    private final RandomEscape randomEscape = new RandomEscape();
    private final InputStream input;
    private NestedInputStream current;
    private IOException exception;
    private int escape;
    private boolean closed;
    private boolean eof;

    public InputStreamReader(InputStream input) {
        this.input = input;
        this.escape = this.randomEscape.next();
    }

    public synchronized InputStream read() throws IOException {
        int firstValue;
        if (this.closed) {
            throw new IOException("this instance is closed");
        }
        if (this.exception != null) {
            throw new IOException("exception on the underlying stream", this.exception);
        }
        if (this.eof) {
            return null;
        }
        if (this.current != null) {
            this.current.close();
            if (!this.current.isEOF()) {
                while (this.readNext() >= 0) {
                }
            }
        }
        if ((firstValue = this.readNext()) == -1) {
            return null;
        }
        this.current = new NestedInputStream(firstValue);
        return this.current;
    }

    private int readNext() throws IOException {
        if (this.eof) {
            return -1;
        }
        int ch = this.input.read();
        if (ch == -1) {
            this.eof = true;
            return -1;
        }
        if (ch == this.escape) {
            ch = this.input.read();
            if (ch == -1) {
                this.eof = true;
                return -1;
            }
            int prevEscape = this.escape;
            this.escape = this.randomEscape.next();
            switch (ch ^= this.escape) {
                case 1: {
                    return prevEscape;
                }
                case 2: {
                    return -2;
                }
            }
            throw new IOException("rec'd unexpected escape code " + ch);
        }
        return ch;
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.current != null) {
            this.current.checkInputClose();
        }
    }

    private class NestedInputStream
    extends FilterInputStream {
        private int firstValue;
        private boolean firstRead;
        private boolean closed;
        private boolean eof;

        NestedInputStream(int firstValue) {
            super(InputStreamReader.this.input);
            this.firstRead = true;
            this.firstValue = firstValue;
        }

        @Override
        public int read() throws IOException {
            InputStreamReader inputStreamReader = InputStreamReader.this;
            synchronized (inputStreamReader) {
                if (this.closed) {
                    throw new IOException("stream is closed");
                }
                if (InputStreamReader.this.exception != null) {
                    throw new IOException("exception on the underlying stream", InputStreamReader.this.exception);
                }
                if (this.eof) {
                    return -1;
                }
                try {
                    int ch;
                    if (this.firstRead) {
                        ch = this.firstValue;
                        this.firstRead = false;
                    } else {
                        ch = InputStreamReader.this.readNext();
                    }
                    switch (ch) {
                        case -1: {
                            throw new IOException("underlying stream was truncated");
                        }
                        case -2: {
                            this.eof = true;
                            return -1;
                        }
                    }
                    return ch;
                }
                catch (IOException e) {
                    InputStreamReader.this.exception = e;
                    throw e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            InputStreamReader inputStreamReader = InputStreamReader.this;
            synchronized (inputStreamReader) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                this.checkInputClose();
            }
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            int count;
            if (len < 0 || off < 0 || off + len > buf.length) {
                throw new IndexOutOfBoundsException();
            }
            for (count = 0; count < len; ++count) {
                int ch = this.read();
                if (ch == -1) {
                    if (count != 0) break;
                    return -1;
                }
                buf[off++] = (byte)ch;
            }
            return count;
        }

        @Override
        public long skip(long num) throws IOException {
            long count;
            for (count = 0L; count < num && this.read() != -1; ++count) {
            }
            return count;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void mark(int readlimit) {
        }

        @Override
        public void reset() throws IOException {
            throw new IOException("mark/reset not supported");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkInputClose() throws IOException {
            InputStreamReader inputStreamReader = InputStreamReader.this;
            synchronized (inputStreamReader) {
                if (this.closed && InputStreamReader.this.closed) {
                    this.in.close();
                }
            }
        }

        public boolean isEOF() {
            return this.eof;
        }
    }
}

