/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.java;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.dellroad.stuff.java.PrimitiveSwitch;

public abstract class Primitive<T>
implements Comparator<T>,
Serializable {
    public static final Primitive<Void> VOID = new Primitive<Void>(Void.TYPE, Void.class, 'V', 0, ""){
        private static final long serialVersionUID = -7949695577609812484L;

        @Override
        public <R> R visit(PrimitiveSwitch<R> pswitch) {
            return pswitch.caseVoid();
        }

        @Override
        public Void getDefaultValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compare(Void value1, Void value2) {
            throw new NullPointerException();
        }

        @Override
        protected Void doParseValue(String string) {
            throw new IllegalArgumentException();
        }
    };
    public static final Primitive<Boolean> BOOLEAN = new Primitive<Boolean>(Boolean.TYPE, Boolean.class, 'Z', 1, "true|false"){
        private static final long serialVersionUID = 6929408176584630874L;

        @Override
        public <R> R visit(PrimitiveSwitch<R> pswitch) {
            return pswitch.caseBoolean();
        }

        @Override
        public Boolean getDefaultValue() {
            return false;
        }

        @Override
        public int compare(Boolean value1, Boolean value2) {
            return Boolean.compare(value1, value2);
        }

        @Override
        protected Boolean doParseValue(String string) {
            return Boolean.parseBoolean(string);
        }
    };
    public static final Primitive<Byte> BYTE = new Primitive<Byte>(Byte.TYPE, Byte.class, 'B', 1, "(?i)(\\+|-)?(((0x|#)0*(\\p{XDigit}{1,2}))|(0+[0-7]{0,3})|([1-9][0-9]{0,2}))"){
        private static final long serialVersionUID = -5720606133595207151L;

        @Override
        public <R> R visit(PrimitiveSwitch<R> pswitch) {
            return pswitch.caseByte();
        }

        @Override
        public Byte getDefaultValue() {
            return (byte)0;
        }

        @Override
        public int compare(Byte value1, Byte value2) {
            return Byte.compare(value1, value2);
        }

        @Override
        protected Byte doParseValue(String string) {
            return Byte.decode(string);
        }
    };
    public static final Primitive<Character> CHARACTER = new Primitive<Character>(Character.TYPE, Character.class, 'C', 2, "(?s)."){
        private static final long serialVersionUID = -6140764391849287341L;

        @Override
        public <R> R visit(PrimitiveSwitch<R> pswitch) {
            return pswitch.caseCharacter();
        }

        @Override
        public Character getDefaultValue() {
            return Character.valueOf('\u0000');
        }

        @Override
        public int compare(Character value1, Character value2) {
            return Character.compare(value1.charValue(), value2.charValue());
        }

        @Override
        protected Character doParseValue(String string) {
            if (string.length() != 1) {
                throw new IllegalArgumentException("string has length " + string.length() + " != 1");
            }
            return Character.valueOf(string.charAt(0));
        }
    };
    public static final Primitive<Short> SHORT = new Primitive<Short>(Short.TYPE, Short.class, 'S', 2, "(?i)(\\+|-)?(((0x|#)0*(\\p{XDigit}{1,4}))|(0+[0-7]{0,6})|([1-9][0-9]{0,4}))"){
        private static final long serialVersionUID = -7258485621744729715L;

        @Override
        public <R> R visit(PrimitiveSwitch<R> pswitch) {
            return pswitch.caseShort();
        }

        @Override
        public Short getDefaultValue() {
            return (short)0;
        }

        @Override
        public int compare(Short value1, Short value2) {
            return Short.compare(value1, value2);
        }

        @Override
        protected Short doParseValue(String string) {
            return Short.decode(string);
        }
    };
    public static final Primitive<Integer> INTEGER = new Primitive<Integer>(Integer.TYPE, Integer.class, 'I', 4, "(?i)(\\+|-)?(((0x|#)0*(\\p{XDigit}{1,8}))|(0+[0-7]{0,11})|([1-9][0-9]{0,9}))"){
        private static final long serialVersionUID = 6417724691359947003L;

        @Override
        public <R> R visit(PrimitiveSwitch<R> pswitch) {
            return pswitch.caseInteger();
        }

        @Override
        public Integer getDefaultValue() {
            return 0;
        }

        @Override
        public int compare(Integer value1, Integer value2) {
            return Integer.compare(value1, value2);
        }

        @Override
        protected Integer doParseValue(String string) {
            return Integer.decode(string);
        }
    };
    public static final Primitive<Float> FLOAT = new Primitive<Float>(Float.TYPE, Float.class, 'F', 4, "[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))))"){
        private static final long serialVersionUID = -5540301676120287470L;

        @Override
        public <R> R visit(PrimitiveSwitch<R> pswitch) {
            return pswitch.caseFloat();
        }

        @Override
        public Float getDefaultValue() {
            return Float.valueOf(0.0f);
        }

        @Override
        public int compare(Float value1, Float value2) {
            return Float.compare(value1.floatValue(), value2.floatValue());
        }

        @Override
        protected Float doParseValue(String string) {
            return Float.valueOf(Float.parseFloat(string));
        }
    };
    public static final Primitive<Long> LONG = new Primitive<Long>(Long.TYPE, Long.class, 'J', 8, "(?i)(\\+|-)?(((0x|#)0*(\\p{XDigit}{1,16}))|(0+[0-7]{0,22})|([1-9][0-9]{0,18}))"){
        private static final long serialVersionUID = -6797953814533403166L;

        @Override
        public <R> R visit(PrimitiveSwitch<R> pswitch) {
            return pswitch.caseLong();
        }

        @Override
        public Long getDefaultValue() {
            return 0L;
        }

        @Override
        public int compare(Long value1, Long value2) {
            return Long.compare(value1, value2);
        }

        @Override
        protected Long doParseValue(String string) {
            return Long.decode(string);
        }
    };
    public static final Primitive<Double> DOUBLE = new Primitive<Double>(Double.TYPE, Double.class, 'D', 8, "[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))))"){
        private static final long serialVersionUID = -1216396451473814398L;

        @Override
        public <R> R visit(PrimitiveSwitch<R> pswitch) {
            return pswitch.caseDouble();
        }

        @Override
        public Double getDefaultValue() {
            return 0.0;
        }

        @Override
        public int compare(Double value1, Double value2) {
            return Double.compare(value1, value2);
        }

        @Override
        protected Double doParseValue(String string) {
            return Double.parseDouble(string);
        }
    };
    private static final long serialVersionUID = 1445360538621930171L;
    private static HashMap<Class<?>, Primitive<?>> classMap;
    private final Class<T> primType;
    private final Class<T> wrapType;
    private final char letter;
    private final byte size;
    private final Pattern parsePattern;

    Primitive(Class<T> primType, Class<T> wrapType, char letter, int size, String parsePattern) {
        this.primType = primType;
        this.wrapType = wrapType;
        this.letter = letter;
        this.size = (byte)size;
        Pattern pattern = this.parsePattern = parsePattern != null ? Pattern.compile(parsePattern) : null;
        if (classMap == null) {
            classMap = new HashMap();
        }
        classMap.put(primType, this);
        classMap.put(wrapType, this);
    }

    public abstract <R> R visit(PrimitiveSwitch<R> var1);

    public abstract T getDefaultValue();

    public String getName() {
        return this.primType.getName();
    }

    public String getLongName() {
        return this.wrapType.getSimpleName();
    }

    public char getLetter() {
        return this.letter;
    }

    public int getSize() {
        return this.size;
    }

    public Class<T> getType() {
        return this.primType;
    }

    public Class<T> getWrapperType() {
        return this.wrapType;
    }

    public Pattern getParsePattern() {
        if (this.parsePattern == null) {
            throw new UnsupportedOperationException();
        }
        return this.parsePattern;
    }

    public Method getUnwrapMethod() {
        try {
            return this.wrapType.getMethod(this.getName() + "Value", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public abstract int compare(T var1, T var2);

    public T parseValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null string");
        }
        return this.doParseValue(string);
    }

    abstract T doParseValue(String var1);

    public static Primitive<?> forName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        for (Primitive<?> primitive : Primitive.values()) {
            if (!name.equals(primitive.getName())) continue;
            return primitive;
        }
        return null;
    }

    public static Set<Primitive<?>> values() {
        return new HashSet(classMap.values());
    }

    public static Primitive<?> get(Class<?> c) {
        return classMap.get(c);
    }

    public String toString() {
        return this.wrapType.getSimpleName().toUpperCase();
    }

    private static final class DoubleFormat {
        private static final String DIGITS = "(\\p{Digit}+)";
        private static final String HEX_DIGITS = "(\\p{XDigit}+)";
        private static final String EXPONENT = "[eE][+-]?(\\p{Digit}+)";
        private static final String REGEX = "[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))))";

        private DoubleFormat() {
        }
    }
}

