/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.dellroad.stuff.net.SocketHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SocketAcceptor {
    public static final int DEFAULT_BACKLOG = 50;
    private static final long NOTIFICATION_INTERVAL = 5000000000L;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final HashSet<SocketInfo> connections = new HashSet();
    private InetAddress address;
    private int backlog = 50;
    private int port;
    private int maxConnections;
    private ServerSocket serverSocket;
    private Thread serverThread;
    private boolean started;

    public synchronized InetAddress getInetAddress() {
        return this.address;
    }

    public synchronized void setInetAddress(InetAddress address) {
        this.address = address;
    }

    public synchronized int getBacklog() {
        return this.backlog;
    }

    public synchronized void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public synchronized int getMaxConnections() {
        return this.maxConnections;
    }

    public synchronized void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized void setPort(int port) {
        this.port = port;
    }

    @PostConstruct
    public synchronized void start() {
        if (this.port == 0) {
            throw new IllegalArgumentException("TCP port not set");
        }
        if (this.port < 1 || this.port > 65535) {
            throw new IllegalArgumentException("invalid TCP port " + this.port);
        }
        if (this.maxConnections < 0) {
            throw new IllegalArgumentException("invalid maxConnections " + this.maxConnections);
        }
        if (this.started) {
            return;
        }
        String addr = this.address != null ? "" + this.address : "*";
        String threadName = this.getClass().getSimpleName() + "[" + addr + ":" + this.port + "]";
        this.serverThread = new Thread(threadName){

            @Override
            public void run() {
                SocketAcceptor.this.run();
            }
        };
        try {
            this.serverSocket = this.createServerSocket();
        }
        catch (IOException e) {
            throw new RuntimeException("error creating server socket", e);
        }
        if (this.serverSocket == null) {
            throw new RuntimeException("createServerSocket() returned a null socket");
        }
        this.serverThread.start();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void run() {
        try {
            while (true) {
                SocketAcceptor socketAcceptor = this;
                // MONITORENTER : socketAcceptor
                boolean logged22 = false;
                while (this.serverSocket != null && this.maxConnections > 0 && this.connections.size() >= this.maxConnections) {
                    if (!logged22) {
                        this.log.warn(Thread.currentThread().getName() + " has reached connection limit of " + this.maxConnections + ", temporarily refusing new connections");
                        logged22 = true;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (logged22) {
                    this.log.info(Thread.currentThread().getName() + " is accepting new connections again");
                }
                // MONITOREXIT : socketAcceptor
                SocketAcceptor logged22 = this;
                // MONITORENTER : logged22
                ServerSocket serverSocketCopy = this.serverSocket;
                // MONITOREXIT : logged22
                if (serverSocketCopy == null) {
                    return;
                }
                final Socket socket = serverSocketCopy.accept();
                String socketDesc = socket.getInetAddress().getHostAddress() + ":" + socket.getPort();
                this.log.info("accepted new TCP connection from " + socketDesc);
                final SocketHandler handler = this.getSocketHandler(socket);
                if (handler == null) {
                    this.log.info("null handler returned by getSocketHandler, closing connection from " + socketDesc);
                    try {
                        socket.close();
                    }
                    catch (IOException e) {}
                    continue;
                }
                final SocketInfo socketInfo = new SocketInfo(socket, handler);
                Thread handlerThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            handler.handleConnection(socket);
                        }
                        catch (Throwable t) {
                            SocketAcceptor.this.log.error("error handling connection in " + Thread.currentThread().getName(), t);
                        }
                        finally {
                            SocketAcceptor socketAcceptor = SocketAcceptor.this;
                            synchronized (socketAcceptor) {
                                SocketAcceptor.this.connections.remove(socketInfo);
                                SocketAcceptor.this.notifyAll();
                            }
                            try {
                                socket.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                };
                handlerThread.setName(handler.getClass().getSimpleName() + "[" + socketDesc + "]");
                socketInfo.setThread(handlerThread);
                SocketAcceptor socketAcceptor2 = this;
                // MONITORENTER : socketAcceptor2
                if (this.serverSocket == null) {
                    this.log.info("discarding connection from " + socketDesc + " due to shutdown");
                    try {
                        socket.close();
                        return;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return;
                }
                handlerThread.start();
                this.connections.add(socketInfo);
                // MONITOREXIT : socketAcceptor2
            }
        }
        catch (IOException e) {
            SocketAcceptor socketAcceptor = this;
            // MONITORENTER : socketAcceptor
            boolean expected = this.serverSocket == null;
            // MONITOREXIT : socketAcceptor
            if (expected) return;
            this.log.error("exception in acceptor thread " + Thread.currentThread().getName(), (Throwable)e);
            return;
        }
        catch (Throwable t) {
            try {
                this.log.error("exception in acceptor thread " + Thread.currentThread().getName(), t);
            }
            catch (Throwable throwable) {
                this.log.info("acceptor thread " + Thread.currentThread().getName() + " exiting");
                this.closeServerSocket();
                SocketAcceptor socketAcceptor = this;
                // MONITORENTER : socketAcceptor
                this.serverThread = null;
                this.notifyAll();
                // MONITOREXIT : socketAcceptor
                throw throwable;
            }
            this.log.info("acceptor thread " + Thread.currentThread().getName() + " exiting");
            this.closeServerSocket();
            SocketAcceptor socketAcceptor = this;
            // MONITORENTER : socketAcceptor
            this.serverThread = null;
            this.notifyAll();
            // MONITOREXIT : socketAcceptor
            return;
        }
        finally {
            this.log.info("acceptor thread " + Thread.currentThread().getName() + " exiting");
            this.closeServerSocket();
            SocketAcceptor e = this;
        }
    }

    @PreDestroy
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        if (this.serverThread != null) {
            this.log.info("stopping acceptor thread");
        }
        this.closeServerSocket();
        while (this.serverThread != null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        for (SocketInfo socketInfo : this.connections) {
            try {
                socketInfo.getHandler().stop(socketInfo.getThread(), socketInfo.getSocket());
            }
            catch (Throwable t) {
                this.log.error("error stopping " + socketInfo.getHandler(), t);
            }
            try {
                socketInfo.getSocket().close();
            }
            catch (IOException e) {}
        }
        long lastTime = System.nanoTime();
        boolean logged = false;
        while (!this.connections.isEmpty()) {
            long nextTime = System.nanoTime();
            if (!logged || nextTime - lastTime > 5000000000L) {
                this.log.info("waiting for " + this.connections.size() + " active connection(s) to stop...");
                logged = true;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (logged) {
            this.log.info("all active connection(s) have stopped");
        }
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeServerSocket() {
        if (this.serverSocket == null) {
            return;
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.serverSocket = null;
        }
    }

    protected synchronized ServerSocket createServerSocket() throws IOException {
        ServerSocket socket = new ServerSocket(this.port, this.backlog, this.address);
        socket.setReuseAddress(true);
        return socket;
    }

    protected abstract SocketHandler getSocketHandler(Socket var1) throws IOException;

    private static class SocketInfo {
        private final Socket socket;
        private final SocketHandler handler;
        private Thread thread;

        SocketInfo(Socket socket, SocketHandler handler) {
            this.socket = socket;
            this.handler = handler;
        }

        public Socket getSocket() {
            return this.socket;
        }

        public SocketHandler getHandler() {
            return this.handler;
        }

        public Thread getThread() {
            return this.thread;
        }

        public void setThread(Thread thread) {
            this.thread = thread;
        }
    }
}

