/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.NetworkChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import org.dellroad.stuff.net.ChannelNetwork;
import org.dellroad.stuff.net.Network;
import org.dellroad.stuff.net.SelectorSupport;
import org.dellroad.stuff.net.TCPConnection;

public class TCPNetwork
extends ChannelNetwork
implements Network {
    public static final long DEFAULT_CONNECT_TIMEOUT = 20000L;
    private final int defaultPort;
    private InetSocketAddress listenAddress;
    private long connectTimeout = 20000L;
    private ServerSocketChannel serverSocketChannel;
    private SelectionKey selectionKey;

    public TCPNetwork(int defaultPort) {
        if (defaultPort <= 0 || defaultPort > 65535) {
            throw new IllegalArgumentException("invalid default port " + defaultPort);
        }
        this.defaultPort = defaultPort;
        this.listenAddress = new InetSocketAddress(this.defaultPort);
    }

    public synchronized InetSocketAddress getListenAddress() {
        return this.listenAddress;
    }

    public synchronized void setListenAddress(InetSocketAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("null address");
        }
        this.listenAddress = address;
    }

    public synchronized long getConnectTimeout() {
        return this.connectTimeout;
    }

    public synchronized void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start(Network.Handler handler) throws IOException {
        super.start(handler);
        boolean successful = false;
        try {
            if (this.serverSocketChannel != null) {
                return;
            }
            this.serverSocketChannel = ServerSocketChannel.open();
            this.configureServerSocketChannel(this.serverSocketChannel);
            this.serverSocketChannel.bind(this.listenAddress);
            this.selectionKey = this.createSelectionKey(this.serverSocketChannel, new SelectorSupport.IOHandler(){

                @Override
                public void serviceIO(SelectionKey key) throws IOException {
                    if (key.isAcceptable()) {
                        TCPNetwork.this.handleAccept();
                    }
                }

                @Override
                public void close(Throwable cause) {
                    TCPNetwork.this.log.error("stopping " + this + " due to exception", cause);
                    TCPNetwork.this.stop();
                }
            });
            this.selectForAccept(true);
            successful = true;
        }
        finally {
            if (!successful) {
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        TCPNetwork tCPNetwork = this;
        synchronized (tCPNetwork) {
            if (this.serverSocketChannel != null) {
                try {
                    this.serverSocketChannel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.serverSocketChannel = null;
            }
            this.selectionKey = null;
        }
    }

    public static String parseAddressPart(String address) {
        return (String)TCPNetwork.parseAddress(address, 0)[0];
    }

    public static int parsePortPart(String address, int defaultPort) {
        return (Integer)TCPNetwork.parseAddress(address, defaultPort)[1];
    }

    private static Object[] parseAddress(String string, int defaultPort) {
        int colon = string.lastIndexOf(58);
        if (colon == -1) {
            return new Object[]{string, defaultPort};
        }
        try {
            int port = Integer.parseInt(string.substring(colon + 1), 10);
            if (port < 1 || port > 65535) {
                return new Object[]{string, defaultPort};
            }
            return new Object[]{string.substring(0, colon), port};
        }
        catch (Exception e) {
            return new Object[]{string, defaultPort};
        }
    }

    protected void configureServerSocketChannel(ServerSocketChannel serverSocketChannel) {
    }

    protected void configureSocketChannel(SocketChannel socketChannel) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[port=" + this.listenAddress.getPort() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAccept() throws IOException {
        SocketChannel socketChannel;
        assert (this.isServiceThread());
        if (this.connectionMap.size() >= this.getMaxConnections()) {
            this.log.warn("too many network connections (" + this.connectionMap.size() + " >= " + this.getMaxConnections() + "), not accepting any more (for now)");
            this.selectForAccept(false);
            return;
        }
        TCPNetwork tCPNetwork = this;
        synchronized (tCPNetwork) {
            if (this.serverSocketChannel == null || (socketChannel = this.serverSocketChannel.accept()) == null) {
                return;
            }
        }
        this.log.info("accepted incoming connection from " + socketChannel.getRemoteAddress());
        ((SocketChannel)socketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true)).setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
        this.configureSocketChannel(socketChannel);
        InetSocketAddress remote = (InetSocketAddress)socketChannel.socket().getRemoteSocketAddress();
        String peer = remote.getHostString() + (remote.getPort() != this.defaultPort ? ":" + remote.getPort() : "");
        TCPConnection connection = (TCPConnection)this.connectionMap.get(peer);
        if (connection != null) {
            SocketAddress oldAddr = connection.getSocketChannel().socket().getLocalSocketAddress();
            SocketAddress newAddr = socketChannel.getRemoteAddress();
            String oldDesc = oldAddr.toString().replaceAll("^[^/]*/", "");
            String newDesc = newAddr.toString().replaceAll("^[^/]*/", "");
            int diff = newDesc.compareTo(oldDesc);
            this.log.info("connection mid-air collision: old: " + oldDesc + ", new: " + newDesc + ", winner: " + (diff < 0 ? "new" : (diff > 0 ? "old" : "neither (?)")));
            if (diff >= 0) {
                this.log.info("rejecting incoming connection from " + socketChannel.getRemoteAddress() + " as duplicate");
                socketChannel.close();
                socketChannel = null;
            }
            if (diff <= 0) {
                String remoteAddress = socketChannel != null ? "" + socketChannel.getRemoteAddress() : "<same>";
                this.log.info("closing existing duplicate connection to " + remoteAddress);
                this.connectionMap.remove(peer);
                connection.close(new IOException("duplicate connection"));
                connection = null;
            }
        }
        if (connection == null && socketChannel != null) {
            connection = new TCPConnection(this, peer, socketChannel);
            this.connectionMap.put(peer, connection);
            this.handleOutputQueueEmpty(connection);
        }
    }

    private void selectForAccept(boolean enabled) throws IOException {
        if (this.selectionKey == null) {
            return;
        }
        if (enabled && (this.selectionKey.interestOps() & 0x10) == 0) {
            this.selectFor(this.selectionKey, 16, true);
            if (this.log.isDebugEnabled()) {
                this.log.debug(this + " started listening for incoming connections");
            }
        } else if (!enabled && (this.selectionKey.interestOps() & 0x10) != 0) {
            this.selectFor(this.selectionKey, 16, false);
            if (this.log.isDebugEnabled()) {
                this.log.debug(this + " stopped listening for incoming connections");
            }
        }
    }

    @Override
    protected String normalizePeerName(String peer) {
        if (peer == null) {
            throw new IllegalArgumentException("null peer");
        }
        int colon = peer.lastIndexOf(58);
        if (colon == -1) {
            peer = peer + ":" + this.defaultPort;
        }
        return peer;
    }

    @Override
    protected synchronized TCPConnection createConnection(String peer) throws IOException {
        InetSocketAddress socketAddress;
        NetworkChannel socketChannel;
        block5: {
            socketChannel = ((SocketChannel)SocketChannel.open().setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true)).setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
            this.configureSocketChannel((SocketChannel)socketChannel);
            ((AbstractSelectableChannel)((Object)socketChannel)).configureBlocking(false);
            if (this.log.isDebugEnabled()) {
                this.log.debug(this + " looking up peer address `" + peer + "'");
            }
            socketAddress = null;
            try {
                socketAddress = new InetSocketAddress(TCPNetwork.parseAddressPart(peer), TCPNetwork.parsePortPart(peer, this.defaultPort));
            }
            catch (IllegalArgumentException e) {
                if (!this.log.isTraceEnabled()) break block5;
                this.log.trace(this + " peer address `" + peer + "' is invalid", (Throwable)e);
            }
        }
        if (socketAddress == null || socketAddress.isUnresolved()) {
            throw new IOException("invalid or unresolvable peer address `" + peer + "'");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + ": resolved peer address `" + peer + "' to " + socketAddress.getAddress() + "; now initiating connection");
        }
        ((SocketChannel)socketChannel).connect(socketAddress);
        return new TCPConnection(this, peer, (SocketChannel)socketChannel);
    }

    @Override
    protected void serviceHousekeeping() {
        super.serviceHousekeeping();
        try {
            this.selectForAccept(this.connectionMap.size() < this.getMaxConnections());
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception", e);
        }
    }
}

