/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dellroad.stuff.graph.TopologicalSorter;
import org.dellroad.stuff.schema.DatabaseAction;
import org.dellroad.stuff.schema.SchemaUpdate;
import org.dellroad.stuff.schema.SchemaUpdateEdgeLister;
import org.dellroad.stuff.schema.UnrecognizedUpdateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaUpdater<D, T> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private Collection<? extends SchemaUpdate<T>> updates;
    private boolean ignoreUnrecognizedUpdates;

    public Collection<? extends SchemaUpdate<T>> getUpdates() {
        return this.updates;
    }

    public void setUpdates(Collection<? extends SchemaUpdate<T>> updates) {
        this.updates = updates;
    }

    public boolean isIgnoreUnrecognizedUpdates() {
        return this.ignoreUnrecognizedUpdates;
    }

    public void setIgnoreUnrecognizedUpdates(boolean ignoreUnrecognizedUpdates) {
        this.ignoreUnrecognizedUpdates = ignoreUnrecognizedUpdates;
    }

    public synchronized void initializeAndUpdateDatabase(final D database) throws Exception {
        this.log.info("verifying database " + database);
        this.applyInTransaction(database, new DatabaseAction<T>(){

            @Override
            public void apply(T transaction) throws Exception {
                if (!AbstractSchemaUpdater.this.databaseNeedsInitialization(transaction)) {
                    AbstractSchemaUpdater.this.log.debug("detected already-initialized database " + database);
                    return;
                }
                AbstractSchemaUpdater.this.log.info("uninitialized database detected; initializing " + database);
                AbstractSchemaUpdater.this.initializeDatabase(transaction);
                for (String updateName : AbstractSchemaUpdater.this.getAllUpdateNames()) {
                    AbstractSchemaUpdater.this.recordUpdateApplied(transaction, updateName);
                }
            }
        });
        this.applySchemaUpdates(database);
        this.log.info("database verification completed for " + database);
    }

    public static boolean isValidUpdateName(String updateName) {
        return updateName.length() > 0 && updateName.trim().length() == updateName.length();
    }

    protected abstract boolean databaseNeedsInitialization(T var1) throws Exception;

    protected abstract void initializeDatabase(T var1) throws Exception;

    protected abstract T openTransaction(D var1) throws Exception;

    protected abstract void commitTransaction(T var1) throws Exception;

    protected abstract void rollbackTransaction(T var1) throws Exception;

    protected abstract Set<String> getAppliedUpdateNames(T var1) throws Exception;

    protected abstract void recordUpdateApplied(T var1, String var2) throws Exception;

    protected Comparator<SchemaUpdate<T>> getOrderingTieBreaker() {
        return new UpdateByNameComparator();
    }

    protected String generateMultiUpdateName(SchemaUpdate<T> update, int index) {
        return String.format("%s-%05d", update.getName(), index + 1);
    }

    protected List<String> getAllUpdateNames() throws Exception {
        ArrayList<SchemaUpdate<T>> updateList = new ArrayList<SchemaUpdate<T>>(this.getUpdates());
        ArrayList<String> updateNameList = new ArrayList<String>(updateList.size());
        Collections.sort(updateList, new UpdateByNameComparator());
        for (SchemaUpdate<T> update : updateList) {
            updateNameList.addAll(this.getUpdateNames(update));
        }
        return updateNameList;
    }

    protected void apply(T transaction, DatabaseAction<T> action) throws Exception {
        action.apply(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyInTransaction(D database, DatabaseAction<T> action) throws Exception {
        T transaction = this.openTransaction(database);
        boolean success = false;
        try {
            this.apply(transaction, action);
            this.commitTransaction(transaction);
            success = true;
        }
        finally {
            if (!success) {
                this.rollbackTransaction(transaction);
            }
        }
    }

    private void applySchemaUpdates(D database) throws Exception {
        if (this.getUpdates() == null) {
            throw new IllegalArgumentException("no updates configured");
        }
        HashSet<SchemaUpdate<T>> allUpdates = new HashSet<SchemaUpdate<T>>(this.getUpdates());
        TreeMap<String, SchemaUpdate<T>> updateMap = new TreeMap<String, SchemaUpdate<T>>();
        for (SchemaUpdate<T> update : allUpdates) {
            for (String string : this.getUpdateNames(update)) {
                if (!AbstractSchemaUpdater.isValidUpdateName(string)) {
                    throw new IllegalArgumentException("illegal schema update name `" + string + "'");
                }
                if (updateMap.put(string, update) == null) continue;
                throw new IllegalArgumentException("duplicate schema update name `" + string + "'");
            }
        }
        this.log.debug("these are all known schema updates: " + updateMap.keySet());
        for (SchemaUpdate<T> update : allUpdates) {
            for (SchemaUpdate schemaUpdate : update.getRequiredPredecessors()) {
                if (allUpdates.contains(schemaUpdate)) continue;
                throw new IllegalArgumentException("schema update `" + update.getName() + "' has a required predecessor named `" + schemaUpdate.getName() + "' that is not a configured update");
            }
        }
        List<SchemaUpdate<T>> updateList = new TopologicalSorter<SchemaUpdate<T>>(allUpdates, new SchemaUpdateEdgeLister(), this.getOrderingTieBreaker()).sortEdgesReversed();
        final HashSet appliedUpdateNames = new HashSet();
        this.applyInTransaction(database, new DatabaseAction<T>(){

            @Override
            public void apply(T transaction) throws Exception {
                appliedUpdateNames.addAll(AbstractSchemaUpdater.this.getAppliedUpdateNames(transaction));
            }
        });
        this.log.debug("these are the already-applied schema updates: " + appliedUpdateNames);
        TreeSet unknownUpdateNames = new TreeSet(appliedUpdateNames);
        unknownUpdateNames.removeAll(updateMap.keySet());
        if (!unknownUpdateNames.isEmpty()) {
            if (!this.isIgnoreUnrecognizedUpdates()) {
                throw new UnrecognizedUpdateException(unknownUpdateNames.size() + " unrecognized update(s) have already been applied: " + unknownUpdateNames);
            }
            this.log.info("ignoring " + unknownUpdateNames.size() + " unrecognized update(s) already applied: " + unknownUpdateNames);
        }
        updateMap.keySet().removeAll(appliedUpdateNames);
        HashSet hashSet = new HashSet(updateMap.values());
        Iterator<SchemaUpdate<T>> i = updateList.iterator();
        while (i.hasNext()) {
            if (hashSet.contains(i.next())) continue;
            i.remove();
        }
        if (updateList.isEmpty()) {
            this.log.info("no schema updates are required");
            return;
        }
        LinkedHashSet<String> remainingUpdateNames = new LinkedHashSet<String>(updateMap.size());
        for (SchemaUpdate<T> update : updateList) {
            ArrayList<String> updateNames = this.getUpdateNames(update);
            updateNames.removeAll(appliedUpdateNames);
            remainingUpdateNames.addAll(updateNames);
        }
        this.log.info("applying " + remainingUpdateNames.size() + " schema update(s): " + remainingUpdateNames);
        for (SchemaUpdate<T> nextUpdate : updateList) {
            final RecordingUpdateHandler updateHandler = new RecordingUpdateHandler(nextUpdate, remainingUpdateNames);
            this.applyInTransaction(database, new DatabaseAction<T>(){

                @Override
                public void apply(T transaction) throws Exception {
                    updateHandler.process(transaction);
                }
            });
        }
    }

    private ArrayList<String> getUpdateNames(SchemaUpdate<T> update) throws Exception {
        final ArrayList<String> names = new ArrayList<String>();
        UpdateHandler updateHandler = new UpdateHandler(update){

            @Override
            protected void handleSingleUpdate(T transaction, DatabaseAction<T> action) {
                names.add(this.update.getName());
            }

            @Override
            protected void handleMultiUpdate(T transaction, DatabaseAction<T> action, int index) {
                names.add(AbstractSchemaUpdater.this.generateMultiUpdateName(this.update, index));
            }
        };
        updateHandler.process(null);
        return names;
    }

    private void applyAndRecordUpdate(T transaction, String name, DatabaseAction<T> action) throws Exception {
        if (action != null) {
            this.log.info("applying schema update `" + name + "'");
            this.apply(transaction, action);
        } else {
            this.log.info("recording empty schema update `" + name + "'");
        }
        this.recordUpdateApplied(transaction, name);
    }

    private class UpdateByNameComparator
    implements Comparator<SchemaUpdate<T>> {
        private UpdateByNameComparator() {
        }

        @Override
        public int compare(SchemaUpdate<T> update1, SchemaUpdate<T> update2) {
            return update1.getName().compareTo(update2.getName());
        }
    }

    private class UpdateHandler {
        protected final SchemaUpdate<T> update;
        private final List<? extends DatabaseAction<T>> actions;

        UpdateHandler(SchemaUpdate<T> update) {
            this.update = update;
            this.actions = update.getDatabaseActions();
        }

        public final void process(T transaction) throws Exception {
            switch (this.actions.size()) {
                case 0: {
                    this.handleEmptyUpdate(transaction);
                    break;
                }
                case 1: {
                    this.handleSingleUpdate(transaction, this.actions.get(0));
                    break;
                }
                default: {
                    if (this.update.isSingleAction()) {
                        this.handleSingleMultiUpdate(transaction, this.actions);
                        break;
                    }
                    int index = 0;
                    for (DatabaseAction action : this.actions) {
                        this.handleMultiUpdate(transaction, action, index++);
                    }
                }
            }
        }

        protected void handleEmptyUpdate(T transaction) throws Exception {
            this.handleSingleUpdate(transaction, null);
        }

        protected void handleSingleUpdate(T transaction, DatabaseAction<T> action) throws Exception {
        }

        protected void handleSingleMultiUpdate(T transaction, List<? extends DatabaseAction<T>> actions) throws Exception {
            this.handleSingleUpdate(transaction, null);
        }

        protected void handleMultiUpdate(T transaction, DatabaseAction<T> action, int index) throws Exception {
        }
    }

    private class RecordingUpdateHandler
    extends UpdateHandler {
        private final Set<String> remainingUpdateNames;

        RecordingUpdateHandler(SchemaUpdate<T> update, Set<String> remainingUpdateNames) {
            super(update);
            this.remainingUpdateNames = remainingUpdateNames;
        }

        @Override
        protected void handleEmptyUpdate(T transaction) throws Exception {
            assert (this.remainingUpdateNames.contains(this.update.getName()));
            AbstractSchemaUpdater.this.applyAndRecordUpdate(transaction, this.update.getName(), null);
        }

        @Override
        protected void handleSingleUpdate(T transaction, DatabaseAction<T> action) throws Exception {
            assert (this.remainingUpdateNames.contains(this.update.getName()));
            AbstractSchemaUpdater.this.applyAndRecordUpdate(transaction, this.update.getName(), action);
        }

        @Override
        protected void handleSingleMultiUpdate(T transaction, final List<? extends DatabaseAction<T>> actions) throws Exception {
            assert (this.remainingUpdateNames.contains(this.update.getName()));
            AbstractSchemaUpdater.this.applyAndRecordUpdate(transaction, this.update.getName(), new DatabaseAction<T>(){

                @Override
                public void apply(T transaction) throws Exception {
                    for (DatabaseAction action : actions) {
                        AbstractSchemaUpdater.this.apply(transaction, action);
                    }
                }
            });
        }

        @Override
        protected void handleMultiUpdate(T transaction, DatabaseAction<T> action, int index) throws Exception {
            String updateName = AbstractSchemaUpdater.this.generateMultiUpdateName(this.update, index);
            if (!this.remainingUpdateNames.contains(updateName)) {
                return;
            }
            AbstractSchemaUpdater.this.applyAndRecordUpdate(transaction, updateName, action);
        }
    }
}

