/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.schema;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public abstract class AbstractUpdatingDataSource
implements DataSource {
    private DataSource dataSource;
    private boolean updated;

    public synchronized void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected abstract void updateDataSource(DataSource var1) throws SQLException;

    protected synchronized DataSource getInnerDataSource() {
        return this.dataSource;
    }

    protected synchronized boolean isUpdated() {
        return this.updated;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getUpdatedDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getUpdatedDataSource().getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getUpdatedDataSource().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter pw) throws SQLException {
        this.getUpdatedDataSource().setLogWriter(pw);
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        this.getUpdatedDataSource().setLoginTimeout(timeout);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getUpdatedDataSource().getLoginTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> cl) throws SQLException {
        return cl.cast(this.getUpdatedDataSource());
    }

    @Override
    public boolean isWrapperFor(Class<?> cl) throws SQLException {
        return cl.isInstance(this.getUpdatedDataSource());
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        try {
            return (Logger)DataSource.class.getMethod("getParentLogger", new Class[0]).invoke((Object)this.getUpdatedDataSource(), new Object[0]);
        }
        catch (Exception e) {
            throw new SQLFeatureNotSupportedException(e);
        }
    }

    private synchronized DataSource getUpdatedDataSource() throws SQLException {
        if (!this.updated) {
            if (this.dataSource == null) {
                throw new IllegalArgumentException("no DataSource configured");
            }
            this.updateDataSource(this.dataSource);
            this.updated = true;
        }
        return this.dataSource;
    }
}

