/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.schema;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.dellroad.stuff.schema.DatabaseAction;
import org.dellroad.stuff.schema.SQLCommand;

public class SQLCommandList
implements DatabaseAction<Connection> {
    public static final String DEFAULT_SPLIT_PATTERN = ";[ \\t\\r]*\\n\\s*";
    private String sqlScript;
    private String splitPattern = ";[ \\t\\r]*\\n\\s*";

    public SQLCommandList() {
    }

    public SQLCommandList(String sqlScript) {
        this.setSQLScript(sqlScript);
    }

    public void setSQLScript(String sqlScript) {
        this.sqlScript = sqlScript;
    }

    public void setSplitPattern(String splitPattern) {
        if (splitPattern != null) {
            Pattern.compile(splitPattern);
        }
        this.splitPattern = splitPattern;
    }

    @Override
    public void apply(Connection c) throws SQLException {
        for (SQLCommand sqlCommand : this.split()) {
            sqlCommand.apply(c);
        }
    }

    public List<SQLCommand> split() {
        ArrayList<SQLCommand> list = new ArrayList<SQLCommand>();
        for (String sql : this.splitSQL()) {
            list.add(new SQLCommand(sql));
        }
        return list;
    }

    public String[] splitSQL() {
        String[] stringArray;
        if (this.sqlScript == null) {
            throw new IllegalArgumentException("no SQL script configured");
        }
        if (this.splitPattern != null) {
            stringArray = this.sqlScript.split(this.splitPattern);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.sqlScript;
        }
        String[] sqls = stringArray;
        ArrayList<String> list = new ArrayList<String>(sqls.length);
        for (String sql : sqls) {
            if ((sql = sql.trim()).length() == 0) continue;
            list.add(sql);
        }
        return list.toArray(new String[list.size()]);
    }
}

