/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.sql.Types;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLResultSetWriter {
    public static final Map<Integer, String> TYPE_NAMES;
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private final XMLStreamWriter writer;
    private final String indentSpace;
    private State state = State.LAST_CLOSE;
    private boolean columnNameTags;
    private int nesting;

    public XMLResultSetWriter(XMLStreamWriter writer, int indent) {
        if (writer == null) {
            throw new IllegalArgumentException("null writer");
        }
        this.writer = writer;
        char[] spaces = new char[indent];
        Arrays.fill(spaces, ' ');
        this.indentSpace = new String(spaces);
    }

    public void setColumnNameTags(boolean columnNameTags) {
        this.columnNameTags = columnNameTags;
    }

    public void write(ResultSet resultSet) throws SQLException, XMLStreamException {
        this.write(null, resultSet);
    }

    public void write(String query, ResultSet resultSet) throws SQLException, XMLStreamException {
        int col;
        this.openTag("result-set");
        if (query != null) {
            this.openTag("query");
            this.emitCData(query);
            this.closeTag();
        }
        ResultSetMetaData metaData = resultSet.getMetaData();
        int numColumns = metaData.getColumnCount();
        String[] columnNames = new String[numColumns];
        this.openTag("columns");
        for (col = 1; col <= numColumns; ++col) {
            String nullableDesc;
            int type;
            String typeName;
            int scale;
            int precision;
            String label;
            this.openTag("column");
            this.writer.writeAttribute("index", "" + col);
            String name = metaData.getColumnName(col);
            if (name != null) {
                this.writer.writeAttribute("name", name);
            }
            if ((label = metaData.getColumnLabel(col)) != null) {
                this.writer.writeAttribute("label", label);
            }
            if (this.columnNameTags) {
                String string = label != null ? label : (columnNames[col - 1] = name != null ? name : null);
            }
            if ((precision = metaData.getPrecision(col)) != 0) {
                this.writer.writeAttribute("precision", "" + precision);
            }
            if ((scale = metaData.getScale(col)) != 0) {
                this.writer.writeAttribute("scale", "" + scale);
            }
            this.writer.writeAttribute("type", (typeName = TYPE_NAMES.get(type = metaData.getColumnType(col))) != null ? typeName : "" + type);
            this.writer.writeAttribute("typeName", metaData.getColumnTypeName(col));
            switch (metaData.isNullable(col)) {
                case 1: {
                    nullableDesc = "true";
                    break;
                }
                case 0: {
                    nullableDesc = "false";
                    break;
                }
                default: {
                    nullableDesc = "unknown";
                }
            }
            this.writer.writeAttribute("nullable", nullableDesc);
            this.closeTag();
        }
        this.closeTag();
        this.openTag("data");
        while (resultSet.next()) {
            this.openTag("row");
            for (col = 1; col <= numColumns; ++col) {
                this.writeDataColumn(resultSet, metaData.getColumnType(col), col, columnNames[col - 1]);
            }
            this.closeTag();
        }
        this.closeTag();
        this.closeTag();
    }

    private void writeDataColumn(ResultSet resultSet, int columnType, int col, String columnName) throws SQLException, XMLStreamException {
        Object value = null;
        switch (columnType) {
            case -7: 
            case 16: {
                boolean b = resultSet.getBoolean(col);
                if (resultSet.wasNull()) break;
                value = "" + b;
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                Reader reader = resultSet.getCharacterStream(col);
                if (reader == null) break;
                char[] buf = new char[1024];
                this.openColumnTag(col, columnName);
                try {
                    int len;
                    while ((len = reader.read(buf)) != -1) {
                        this.emitText(buf, 0, len);
                    }
                    reader.close();
                }
                catch (IOException e) {
                    throw (SQLException)new SQLException("error reading from CLOB").initCause(e);
                }
                this.closeTag();
                return;
            }
            case -5: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                value = resultSet.getBigDecimal(col);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                value = resultSet.getInt(col);
                break;
            }
            case 91: {
                Date date = resultSet.getDate(col);
                if (date == null) break;
                value = new SimpleDateFormat(DATE_FORMAT).format(date);
                break;
            }
            case 92: {
                value = resultSet.getTime(col);
                break;
            }
            case 93: {
                Timestamp timestamp = resultSet.getTimestamp(col);
                if (timestamp == null) break;
                value = new SimpleDateFormat(TIMESTAMP_FORMAT).format(timestamp);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                InputStream input = resultSet.getBinaryStream(col);
                if (input == null) break;
                this.openColumnTag(col, columnName);
                try {
                    this.writeBinary(input);
                    input.close();
                }
                catch (IOException e) {
                    throw (SQLException)new SQLException("error reading from BLOB").initCause(e);
                }
                this.closeTag();
                return;
            }
            case -8: {
                try {
                    value = resultSet.getRowId(col);
                }
                catch (AbstractMethodError e) {
                    value = resultSet.getObject(col);
                }
                break;
            }
            default: {
                value = resultSet.getObject(col);
            }
        }
        if (value == null || resultSet.wasNull()) {
            return;
        }
        this.openColumnTag(col, columnName);
        this.emitText(value.toString());
        this.closeTag();
    }

    private void writeBinary(InputStream input) throws IOException, XMLStreamException {
        int len;
        byte[] buf = new byte[1024];
        char[] ch = new char[2];
        while ((len = input.read(buf)) != -1) {
            for (int i = 0; i < len; ++i) {
                int val = buf[i] & 0xFF;
                ch[0] = Character.forDigit(val >> 4, 16);
                ch[1] = Character.forDigit(val & 0xF, 16);
                this.emitText(ch, 0, 2);
            }
        }
    }

    private void openColumnTag(int col, String columnName) throws XMLStreamException {
        this.openTag(columnName != null ? this.xmlify(columnName) : "column");
        this.emitAttr("index", "" + col);
    }

    private String xmlify(String name) {
        StringBuilder buf = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isLetter(ch) || ch == '_' || ch == ':') {
                buf.append(ch);
                continue;
            }
            if (i > 0 && (Character.isDigit(ch) || ch == '.' || ch == '-')) {
                buf.append(ch);
                continue;
            }
            buf.append('_');
        }
        return buf.toString();
    }

    private void openTag(String name) throws XMLStreamException {
        switch (this.state) {
            case LAST_OPEN: {
                this.writer.writeCharacters("\n");
                break;
            }
            case LAST_CLOSE: {
                break;
            }
            default: {
                throw new RuntimeException("mixed element content not supported");
            }
        }
        for (int i = 0; i < this.nesting; ++i) {
            this.writer.writeCharacters(this.indentSpace);
        }
        this.writer.writeStartElement(name);
        ++this.nesting;
        this.state = State.LAST_OPEN;
    }

    private void emitAttr(String name, String value) throws XMLStreamException {
        this.writer.writeAttribute(name, value);
    }

    private void emitText(String content) throws XMLStreamException {
        this.writer.writeCharacters(content);
        this.state = State.LAST_TEXT;
    }

    private void emitText(char[] buf, int off, int len) throws XMLStreamException {
        this.writer.writeCharacters(buf, off, len);
        this.state = State.LAST_TEXT;
    }

    private void emitCData(String content) throws XMLStreamException {
        this.writer.writeCData(content);
        this.state = State.LAST_TEXT;
    }

    private void closeTag() throws XMLStreamException {
        --this.nesting;
        if (this.state == State.LAST_CLOSE) {
            for (int i = 0; i < this.nesting; ++i) {
                this.writer.writeCharacters(this.indentSpace);
            }
        }
        this.writer.writeEndElement();
        if (this.nesting > 0) {
            this.writer.writeCharacters("\n");
        }
        this.state = State.LAST_CLOSE;
    }

    static {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (Field field : Types.class.getDeclaredFields()) {
            if (field.getType() != Integer.TYPE || field.getModifiers() != 25) continue;
            try {
                map.put(field.getInt(null), field.getName());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        TYPE_NAMES = Collections.unmodifiableMap(map);
    }

    private static enum State {
        LAST_OPEN,
        LAST_CLOSE,
        LAST_TEXT;

    }
}

