/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.string;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NamedArgumentFormatter {
    private static final Pattern FORMAT_PARAM_PATTERN = Pattern.compile("%(\\w+)\\$");
    protected final ArrayList<String> fieldList = new ArrayList();
    protected final HashMap<String, Integer> fieldMap = new HashMap();
    protected final String originalFormat;
    protected final String indexedFormat;

    public NamedArgumentFormatter(String format) {
        Matcher matcher = FORMAT_PARAM_PATTERN.matcher(format);
        StringBuilder buf = new StringBuilder();
        int offset = 0;
        while (true) {
            if (!matcher.find(offset)) break;
            String fieldName = matcher.group(1);
            Integer fieldIndex = this.fieldMap.get(fieldName);
            if (fieldIndex == null) {
                fieldIndex = this.fieldList.size();
                this.fieldMap.put(fieldName, fieldIndex);
                this.fieldList.add(fieldName);
            }
            buf.append(format.substring(offset, matcher.start(1)));
            buf.append(fieldIndex + 1);
            offset = matcher.end(1);
        }
        buf.append(format.substring(offset));
        this.originalFormat = format;
        this.indexedFormat = buf.toString();
    }

    public String format(Map<String, Object> argMap) {
        ArrayList<Object> parameterList = new ArrayList<Object>(this.fieldList.size());
        for (String fieldName : this.fieldList) {
            parameterList.add(argMap.get(fieldName));
        }
        return String.format(this.indexedFormat, parameterList.toArray());
    }

    public String getFormat() {
        return this.originalFormat;
    }

    public Set<String> getArgumentNames() {
        return Collections.unmodifiableSet(this.fieldMap.keySet());
    }
}

