/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.string;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.dellroad.stuff.java.Primitive;

public class SimpleObjectParser<T> {
    private final Class<T> targetClass;
    private final HashMap<String, PropertyDescriptor> propertyMap = new HashMap();

    public SimpleObjectParser(Class<T> targetClass) {
        this.targetClass = targetClass;
        this.buildPropertyMap();
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }

    public T parse(String text, String regex, boolean allowSubstringMatch) {
        T target;
        try {
            target = this.targetClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("can't create instance of " + this.targetClass + " using default constructor", e);
        }
        return this.parse(target, text, regex, allowSubstringMatch);
    }

    public T parse(T target, String text, String regex, boolean allowSubstringMatch) {
        HashMap<Integer, String> patternMap = new HashMap<Integer, String>();
        StringBuilder buf = new StringBuilder(regex.length());
        Pattern namedGroup = Pattern.compile("\\(\\{(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\}");
        Matcher matcher = namedGroup.matcher(regex);
        int pos = 0;
        int groupCount = 0;
        while (true) {
            int match = matcher.find(pos) ? matcher.start() : regex.length();
            String chunk = regex.substring(pos, match);
            for (int i = 0; i < chunk.length(); ++i) {
                if (chunk.charAt(i) != '(' || i != 0 && chunk.charAt(i - 1) == '\\' || i != chunk.length() - 1 && chunk.charAt(i + 1) == '?') continue;
                ++groupCount;
            }
            buf.append(chunk);
            if (match == regex.length()) break;
            buf.append('(');
            patternMap.put(++groupCount, matcher.group(1));
            pos = matcher.end();
        }
        Pattern pattern = Pattern.compile(buf.toString());
        int numGroups = pattern.matcher("").groupCount();
        if (numGroups != groupCount) {
            throw new PatternSyntaxException("the given regular expression is not supported (counted " + groupCount + " != " + numGroups + " groups)", regex, 0);
        }
        return this.parse(target, text, pattern, patternMap, allowSubstringMatch);
    }

    public T parse(String text, Pattern pattern, Map<Integer, String> patternMap, boolean allowSubstringMatch) {
        T target;
        try {
            target = this.targetClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("can't create instance of " + this.targetClass + " using default constructor", e);
        }
        return this.parse(target, text, pattern, patternMap, allowSubstringMatch);
    }

    public T parse(T target, String text, Pattern pattern, Map<Integer, String> patternMap, boolean allowSubstringMatch) {
        boolean matches;
        HashMap<Integer, PropertyDescriptor> subgroupMap = new HashMap<Integer, PropertyDescriptor>();
        for (Map.Entry<Integer, String> entry : patternMap.entrySet()) {
            String propName = entry.getValue();
            PropertyDescriptor property = this.propertyMap.get(propName);
            if (property == null) {
                throw new IllegalArgumentException("parseable property \"" + propName + "\" not found in " + this.targetClass);
            }
            subgroupMap.put(entry.getKey(), property);
        }
        Matcher matcher = pattern.matcher(text);
        boolean bl = matches = allowSubstringMatch ? matcher.find() : matcher.matches();
        if (!matches) {
            return null;
        }
        for (Map.Entry entry : subgroupMap.entrySet()) {
            String substring;
            try {
                substring = matcher.group((Integer)entry.getKey());
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("regex subgroup " + entry.getKey() + " does not exist in pattern `" + pattern + "'");
            }
            if (substring == null) continue;
            this.setProperty(target, (PropertyDescriptor)entry.getValue(), substring);
        }
        this.postProcess(target);
        return target;
    }

    public Map<String, PropertyDescriptor> getPropertyMap() {
        return Collections.unmodifiableMap(this.propertyMap);
    }

    public void setProperty(T obj, PropertyDescriptor property, String substring) {
        this.setSimpleProperty(obj, property, substring);
    }

    public void setSimpleProperty(T obj, PropertyDescriptor property, String substring) {
        String value;
        if (property.getPropertyType() == String.class) {
            value = substring;
        } else {
            Primitive<?> prim = Primitive.get(property.getPropertyType());
            if (prim == null) {
                throw new IllegalArgumentException("property `" + property.getName() + "' of " + this.targetClass + " is not a primitive or String");
            }
            value = prim.parseValue(substring);
        }
        try {
            property.getWriteMethod().invoke(obj, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't set property `" + property.getName() + "' of " + this.targetClass, e);
        }
    }

    protected void postProcess(T obj) {
    }

    private void buildPropertyMap() {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(this.targetClass);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        for (PropertyDescriptor property : beanInfo.getPropertyDescriptors()) {
            Method setter;
            if (property instanceof IndexedPropertyDescriptor || (setter = property.getWriteMethod()) == null) continue;
            this.propertyMap.put(property.getName(), property);
        }
    }
}

