/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.string;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringEncoder {
    public static final Pattern ENCODE_PATTERN = Pattern.compile("([\\t\\r\\n\\x20-\\x5b\\x5d-\\ud7ff]|[\\ue000-\\ufffd]|\\\\([\\\\bftrn]|u[\\p{XDigit}]{4}))*");
    public static final Pattern ENQUOTE_PATTERN = Pattern.compile("\"([\\t\\r\\n\\x20\\x21\\x23-\\x5b\\x5d-\\ud7ff]|[\\ue000-\\ufffd]|\\\\([\\\\bftrn\"]|u[\\p{XDigit}]{4}))*\"");
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    private StringEncoder() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String encode(String value, boolean escapeTABNLCR) {
        if (value == null) {
            return value;
        }
        StringBuilder buf = new StringBuilder(value.length() + 4);
        int limit = value.length();
        int i = 0;
        while (true) {
            block14: {
                if (i >= limit) {
                    return buf.toString();
                }
                char ch = value.charAt(i);
                switch (ch) {
                    case '\\': {
                        buf.append('\\').append('\\');
                        break block14;
                    }
                    case '\b': {
                        buf.append('\\').append('b');
                        break block14;
                    }
                    case '\f': {
                        buf.append('\\').append('f');
                        break block14;
                    }
                    case '\t': {
                        if (!escapeTABNLCR) break;
                        buf.append('\\').append('t');
                        break block14;
                    }
                    case '\n': {
                        if (!escapeTABNLCR) break;
                        buf.append('\\').append('n');
                        break block14;
                    }
                    case '\r': {
                        if (!escapeTABNLCR) break;
                        buf.append('\\').append('r');
                        break block14;
                    }
                }
                if (StringEncoder.isValidXMLChar(ch)) {
                    buf.append(ch);
                } else {
                    buf.append('\\');
                    buf.append('u');
                    for (int shift = 12; shift >= 0; shift -= 4) {
                        buf.append(HEXDIGITS[ch >> shift & 0xF]);
                    }
                }
            }
            ++i;
        }
    }

    public static String decode(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(text.length());
        int limit = text.length();
        block8: for (int i = 0; i < limit; ++i) {
            char ch = text.charAt(i);
            if (ch != '\\') {
                if (!StringEncoder.isValidXMLChar(ch)) {
                    throw new IllegalArgumentException(String.format("illegal character 0x%04x in encoded string", ch));
                }
                buf.append(ch);
                continue;
            }
            if (++i >= limit) {
                throw new IllegalArgumentException("illegal trailing '\\' in encoded string");
            }
            ch = text.charAt(i);
            switch (ch) {
                case '\\': {
                    buf.append('\\');
                    continue block8;
                }
                case 'b': {
                    buf.append('\b');
                    continue block8;
                }
                case 't': {
                    buf.append('\t');
                    continue block8;
                }
                case 'n': {
                    buf.append('\n');
                    continue block8;
                }
                case 'f': {
                    buf.append('\f');
                    continue block8;
                }
                case 'r': {
                    buf.append('\r');
                    continue block8;
                }
                default: {
                    if (ch != 'u') {
                        throw new IllegalArgumentException("illegal escape sequence '\\" + ch + "' in encoded string");
                    }
                    if (i + 4 >= limit) {
                        throw new IllegalArgumentException("illegal truncated '\\u' escape sequence in encoded string");
                    }
                    int value = 0;
                    for (int j = 0; j < 4; ++j) {
                        int nibble;
                        if ((nibble = Character.digit(text.charAt(++i), 16)) == -1) {
                            throw new IllegalArgumentException("illegal escape sequence '" + text.substring(i - j - 2, i - j + 4) + "' in encoded string");
                        }
                        assert (nibble >= 0 && nibble <= 15);
                        value = value << 4 | nibble;
                    }
                    buf.append((char)value);
                }
            }
        }
        return buf.toString();
    }

    public static String enquote(String string) {
        if (string == null) {
            return "null";
        }
        return '\"' + StringEncoder.encode(string, true).replaceAll(Pattern.quote("\""), Matcher.quoteReplacement("\\\"")) + '\"';
    }

    public static String enquote(byte[] data, int off, int len) {
        if (data == null) {
            throw new IllegalArgumentException("null data");
        }
        if (off < 0 || len < 0 || off + len < 0 || off + len > data.length) {
            throw new IndexOutOfBoundsException("invalid off/len");
        }
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)(data[off + i] & 0xFF);
        }
        return StringEncoder.enquote(new String(chars));
    }

    public static String dequote(String quotedString) {
        int len = quotedString.length();
        if (len < 2 || quotedString.charAt(0) != '\"' || quotedString.charAt(len - 1) != '\"') {
            throw new IllegalArgumentException("invalid quoted string: not surrounded by quote characters");
        }
        if ((quotedString = quotedString.substring(1, len - 1)).matches("(?s)^(\"|.*[^\\\\]\").*$")) {
            throw new IllegalArgumentException("invalid quoted string: unescaped nested quote character");
        }
        quotedString = quotedString.replaceAll(Pattern.quote("\\\""), Matcher.quoteReplacement("\""));
        return StringEncoder.decode(quotedString);
    }

    public static int enquotedLength(String string) {
        int len = string.length();
        if (len == 0 || string.charAt(0) != '\"') {
            throw new IllegalArgumentException("invalid quoted string prefix: string does not begin with a quote character");
        }
        for (int i = 1; i < len; ++i) {
            if (string.charAt(i) != '\"' || string.charAt(i - 1) == '\\') continue;
            return i + 1;
        }
        throw new IllegalArgumentException("invalid quoted string prefix: no terminating quote character found");
    }

    public static boolean isValidXMLChar(char ch) {
        return ch >= ' ' && ch <= '\ud7ff' || ch == '\n' || ch == '\r' || ch == '\t' || ch >= '\ue000' && ch <= '\ufffd';
    }
}

