/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.validation;

import java.util.Collection;
import java.util.regex.PatternSyntaxException;
import javax.validation.ConstraintDeclarationException;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Pattern;
import org.dellroad.stuff.validation.AbstractValidator;
import org.dellroad.stuff.validation.Pattern;

public class PatternValidator
extends AbstractValidator<Pattern, Object> {
    private java.util.regex.Pattern pattern;

    @Override
    public void initialize(Pattern pattern) {
        super.initialize(pattern);
        int flags = 0;
        for (Pattern.Flag flag : ((Pattern)this.annotation).flags()) {
            flags |= flag.getValue();
        }
        try {
            this.pattern = java.util.regex.Pattern.compile(((Pattern)this.annotation).regexp(), flags);
        }
        catch (PatternSyntaxException e) {
            throw new ConstraintDeclarationException("Invalid regular expression `" + ((Pattern)this.annotation).regexp() + "': " + e.getMessage());
        }
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (value instanceof Collection) {
            return this.isCollectionValid((Collection)value, context);
        }
        return this.pattern.matcher(value.toString()).matches();
    }
}

