/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.validation;

import java.util.Set;
import javax.validation.ConstraintViolation;
import org.dellroad.stuff.validation.ValidationContext;

public final class ValidationUtil {
    private ValidationUtil() {
    }

    public static <T> Set<ConstraintViolation<T>> validate(T obj, Class<?> ... groups) {
        return new ValidationContext<T>(obj, groups).validate();
    }

    public static String describe(Set<? extends ConstraintViolation<?>> violations) {
        if (violations.isEmpty()) {
            return "  (no violations)";
        }
        StringBuilder buf = new StringBuilder(violations.size() * 32);
        for (ConstraintViolation<?> violation : violations) {
            String violationPath = violation.getPropertyPath().toString();
            buf.append("  ");
            if (violationPath.length() > 0) {
                buf.append("[").append(violationPath).append("]: ");
            }
            buf.append(violation.getMessage()).append('\n');
        }
        return buf.toString();
    }
}

