/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.xml;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.EventReaderDelegate;

public abstract class AnnotatedXMLEventReader
extends EventReaderDelegate {
    private byte state;

    public AnnotatedXMLEventReader(XMLEventReader parent) {
        super(parent);
    }

    @Override
    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        XMLEvent event = super.peek();
        if (this.state == 1) {
            event = this.checkAnnotation(event);
        }
        return event;
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        switch (this.state) {
            case 0: {
                XMLEvent event = super.nextEvent();
                if (event.isStartElement()) {
                    this.state = (byte)(this.state + 1);
                }
                return event;
            }
            case 1: {
                this.peek();
                return super.nextEvent();
            }
        }
        return super.nextEvent();
    }

    protected abstract boolean readAnnotationElement(XMLEventReader var1) throws XMLStreamException;

    private XMLEvent checkAnnotation(XMLEvent event) throws XMLStreamException {
        assert (this.state == 1);
        if (this.isWhiteSpace(event) || event instanceof Comment || event.isProcessingInstruction()) {
            return event;
        }
        this.state = (byte)(this.state + 1);
        if (!event.isStartElement() || !this.readAnnotationElement(this.getParent())) {
            return event;
        }
        event = super.peek();
        while (this.isWhiteSpace(event)) {
            super.nextEvent();
            event = super.peek();
        }
        return event;
    }

    private boolean isWhiteSpace(XMLEvent event) {
        return event.isCharacters() && event.asCharacters().isWhiteSpace();
    }
}

