/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.xml;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

public abstract class AnnotatedXMLStreamReader
extends StreamReaderDelegate {
    private byte state;

    public AnnotatedXMLStreamReader(XMLStreamReader parent) {
        super(parent);
    }

    @Override
    public int next() throws XMLStreamException {
        int eventType = super.next();
        switch (this.state) {
            case 0: {
                if (eventType != 1) break;
                this.state = (byte)(this.state + 1);
                break;
            }
            case 1: {
                eventType = this.checkAnnotation(eventType);
                break;
            }
        }
        return eventType;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    protected abstract boolean readAnnotationElement(XMLStreamReader var1) throws XMLStreamException;

    private int checkAnnotation(int eventType) throws XMLStreamException {
        assert (this.state == 1);
        if (this.getParent().isWhiteSpace() || eventType == 5 || eventType == 3) {
            return eventType;
        }
        this.state = (byte)(this.state + 1);
        if (eventType != 1 || !this.readAnnotationElement(this.getParent())) {
            return eventType;
        }
        if (super.getEventType() != 2) {
            throw new XMLStreamException("readAnnotationElement() did not stop on an END_ELEMENT event", this.getLocation());
        }
        do {
            eventType = super.next();
        } while (super.isWhiteSpace());
        return eventType;
    }
}

