/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.xml;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dellroad.stuff.xml.StreamWriterDelegate;

public abstract class AnnotatedXMLStreamWriter
extends StreamWriterDelegate {
    private final StringBuilder trailingSpace = new StringBuilder();
    private byte state;

    public AnnotatedXMLStreamWriter(XMLStreamWriter parent) {
        super(parent);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.checkStartElement();
        super.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.checkStartElement();
        super.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String namespaceURI, String localName) throws XMLStreamException {
        this.checkStartElement();
        super.writeStartElement(prefix, namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        if (this.state == 0) {
            this.writeStartElement(namespaceURI, localName);
        } else {
            super.writeEmptyElement(namespaceURI, localName);
        }
    }

    @Override
    public void writeEmptyElement(String prefix, String namespaceURI, String localName) throws XMLStreamException {
        if (this.state == 0) {
            this.writeStartElement(prefix, namespaceURI, localName);
        } else {
            super.writeEmptyElement(prefix, namespaceURI, localName);
        }
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        if (this.state == 0) {
            this.writeStartElement(localName);
        } else {
            super.writeEmptyElement(localName);
        }
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.checkNonWhitespace();
        super.writeComment(data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.checkNonWhitespace();
        super.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.checkNonWhitespace();
        super.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.checkNonWhitespace();
        super.writeCData(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.checkNonWhitespace();
        super.writeDTD(dtd);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.checkNonWhitespace();
        super.writeEntityRef(name);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.checkWhitespace(text);
        super.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.checkWhitespace(new String(text, start, len));
        super.writeCharacters(text, start, len);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.checkNonWhitespace();
        super.writeEndDocument();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.checkNonWhitespace();
        super.writeEndElement();
    }

    private void checkStartElement() throws XMLStreamException {
        switch (this.state) {
            case 0: {
                this.state = (byte)(this.state + 1);
                break;
            }
            case 1: {
                this.checkNonWhitespace();
                break;
            }
        }
    }

    private void checkNonWhitespace() throws XMLStreamException {
        if (this.state != 1) {
            return;
        }
        this.state = (byte)(this.state + 1);
        this.addAnnotationElement(this.getParent());
        if (this.trailingSpace.length() > 0) {
            super.writeCharacters(this.trailingSpace.toString());
        }
    }

    private void checkWhitespace(String text) throws XMLStreamException {
        if (this.state != 1) {
            return;
        }
        if (text.trim().length() == 0) {
            this.trailingSpace.append(text);
        } else {
            this.checkNonWhitespace();
        }
    }

    protected String getTrailingSpace() {
        return this.trailingSpace.toString();
    }

    protected abstract void addAnnotationElement(XMLStreamWriter var1) throws XMLStreamException;
}

